/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.spring.stat;

import com.alibaba.druid.support.profile.Profiler;
import com.alibaba.druid.support.spring.stat.SpringMethodInfo;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SpringMethodStat {
    private static final ThreadLocal<SpringMethodStat> currentLocal = new ThreadLocal();
    private final SpringMethodInfo methodInfo;
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AtomicInteger concurrentMax = new AtomicInteger();
    private final AtomicLong executeCount = new AtomicLong(0L);
    private final AtomicLong executeErrorCount = new AtomicLong(0L);
    private final AtomicLong executeTimeNano = new AtomicLong();
    private final AtomicLong jdbcFetchRowCount = new AtomicLong();
    private final AtomicLong jdbcUpdateCount = new AtomicLong();
    private final AtomicLong jdbcExecuteCount = new AtomicLong();
    private final AtomicLong jdbcExecuteErrorCount = new AtomicLong();
    private final AtomicLong jdbcExecuteTimeNano = new AtomicLong();
    private final AtomicLong jdbcCommitCount = new AtomicLong();
    private final AtomicLong jdbcRollbackCount = new AtomicLong();
    private final AtomicLong jdbcPoolConnectionOpenCount = new AtomicLong();
    private final AtomicLong jdbcPoolConnectionCloseCount = new AtomicLong();
    private final AtomicLong jdbcResultSetOpenCount = new AtomicLong();
    private final AtomicLong jdbcResultSetCloseCount = new AtomicLong();
    private volatile Throwable lastError;
    private volatile long lastErrorTimeMillis;

    public SpringMethodStat(SpringMethodInfo methodInfo) {
        this.methodInfo = methodInfo;
    }

    public void reset() {
        this.concurrentMax.set(0);
        this.executeCount.set(0L);
        this.executeErrorCount.set(0L);
        this.executeTimeNano.set(0L);
        this.jdbcFetchRowCount.set(0L);
        this.jdbcUpdateCount.set(0L);
        this.jdbcExecuteCount.set(0L);
        this.jdbcExecuteErrorCount.set(0L);
        this.jdbcExecuteTimeNano.set(0L);
        this.jdbcCommitCount.set(0L);
        this.jdbcRollbackCount.set(0L);
        this.jdbcPoolConnectionOpenCount.set(0L);
        this.jdbcPoolConnectionCloseCount.set(0L);
        this.jdbcResultSetOpenCount.set(0L);
        this.jdbcResultSetCloseCount.set(0L);
        this.lastError = null;
        this.lastErrorTimeMillis = 0L;
    }

    public SpringMethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public static SpringMethodStat current() {
        return currentLocal.get();
    }

    public static void setCurrent(SpringMethodStat current) {
        currentLocal.set(current);
    }

    public void beforeInvoke() {
        int max;
        currentLocal.set(this);
        int running = this.runningCount.incrementAndGet();
        while (running > (max = this.concurrentMax.get()) && !this.concurrentMax.compareAndSet(max, running)) {
        }
        this.executeCount.incrementAndGet();
        Profiler.enter(this.methodInfo.getSignature(), "SPRING");
    }

    public void afterInvoke(Throwable error, long nanos) {
        this.runningCount.decrementAndGet();
        this.executeTimeNano.addAndGet(nanos);
        if (error != null) {
            this.executeErrorCount.incrementAndGet();
            this.lastError = error;
            this.lastErrorTimeMillis = System.currentTimeMillis();
        }
        Profiler.release(nanos);
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public Date getLastErrorTime() {
        if (this.lastErrorTimeMillis <= 0L) {
            return null;
        }
        return new Date(this.lastErrorTimeMillis);
    }

    public long getLastErrorTimeMillis() {
        return this.lastErrorTimeMillis;
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public long getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getExecuteCount() {
        return this.executeCount.get();
    }

    public long getExecuteErrorCount() {
        return this.executeErrorCount.get();
    }

    public long getExecuteTimeNano() {
        return this.executeTimeNano.get();
    }

    public long getExecuteTimeMillis() {
        return this.getExecuteTimeNano() / 1000000L;
    }

    public void addJdbcFetchRowCount(long delta) {
        this.jdbcFetchRowCount.addAndGet(delta);
    }

    public long getJdbcFetchRowCount() {
        return this.jdbcFetchRowCount.get();
    }

    public void addJdbcUpdateCount(long updateCount) {
        this.jdbcUpdateCount.addAndGet(updateCount);
    }

    public long getJdbcUpdateCount() {
        return this.jdbcUpdateCount.get();
    }

    public void incrementJdbcExecuteCount() {
        this.jdbcExecuteCount.incrementAndGet();
    }

    public void addJdbcExecuteCount(long executeCount) {
        this.jdbcExecuteCount.addAndGet(executeCount);
    }

    public long getJdbcExecuteCount() {
        return this.jdbcExecuteCount.get();
    }

    public long getJdbcExecuteErrorCount() {
        return this.jdbcExecuteErrorCount.get();
    }

    public void addJdbcExecuteErrorCount(long executeCount) {
        this.jdbcExecuteErrorCount.addAndGet(executeCount);
    }

    public void incrementJdbcExecuteErrorCount() {
        this.jdbcExecuteErrorCount.incrementAndGet();
    }

    public long getJdbcExecuteTimeMillis() {
        return this.getJdbcExecuteTimeNano() / 1000000L;
    }

    public long getJdbcExecuteTimeNano() {
        return this.jdbcExecuteTimeNano.get();
    }

    public void addJdbcExecuteTimeNano(long nano) {
        this.jdbcExecuteTimeNano.addAndGet(nano);
    }

    public void incrementJdbcCommitCount() {
        this.jdbcCommitCount.incrementAndGet();
    }

    public long getJdbcCommitCount() {
        return this.jdbcCommitCount.get();
    }

    public void addJdbcCommitCount(long commitCount) {
        this.jdbcCommitCount.addAndGet(commitCount);
    }

    public void incrementJdbcRollbackCount() {
        this.jdbcRollbackCount.incrementAndGet();
    }

    public long getJdbcRollbackCount() {
        return this.jdbcRollbackCount.get();
    }

    public void addJdbcRollbackCount(long rollbackCount) {
        this.jdbcRollbackCount.addAndGet(rollbackCount);
    }

    public long getJdbcPoolConnectionOpenCount() {
        return this.jdbcPoolConnectionOpenCount.get();
    }

    public void addJdbcPoolConnectionOpenCount(long delta) {
        this.jdbcPoolConnectionOpenCount.addAndGet(delta);
    }

    public void incrementJdbcPoolConnectionOpenCount() {
        this.jdbcPoolConnectionOpenCount.incrementAndGet();
    }

    public long getJdbcPoolConnectionCloseCount() {
        return this.jdbcPoolConnectionCloseCount.get();
    }

    public void addJdbcPoolConnectionCloseCount(long delta) {
        this.jdbcPoolConnectionCloseCount.addAndGet(delta);
    }

    public void incrementJdbcPoolConnectionCloseCount() {
        this.jdbcPoolConnectionCloseCount.incrementAndGet();
    }

    public long getJdbcResultSetOpenCount() {
        return this.jdbcResultSetOpenCount.get();
    }

    public void addJdbcResultSetOpenCount(long delta) {
        this.jdbcResultSetOpenCount.addAndGet(delta);
    }

    public void incrementJdbcResultSetOpenCount() {
        this.jdbcResultSetOpenCount.incrementAndGet();
    }

    public long getJdbcResultSetCloseCount() {
        return this.jdbcResultSetCloseCount.get();
    }

    public void addJdbcResultSetCloseCount(long delta) {
        this.jdbcResultSetCloseCount.addAndGet(delta);
    }

    public void incrementJdbcResultSetCloseCount() {
        this.jdbcResultSetCloseCount.incrementAndGet();
    }

    public Map<String, Object> getStatData() {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("Class", this.getMethodInfo().getClassName());
        data.put("Method", this.getMethodInfo().getSignature());
        data.put("RunningCount", this.getRunningCount());
        data.put("ConcurrentMax", this.getConcurrentMax());
        data.put("ExecuteCount", this.getExecuteCount());
        data.put("ExecuteErrorCount", this.getExecuteErrorCount());
        data.put("ExecuteTimeMillis", this.getExecuteTimeMillis());
        data.put("JdbcCommitCount", this.getJdbcCommitCount());
        data.put("JdbcRollbackCount", this.getJdbcRollbackCount());
        data.put("JdbcPoolConnectionOpenCount", this.getJdbcPoolConnectionOpenCount());
        data.put("JdbcPoolConnectionCloseCount", this.getJdbcPoolConnectionCloseCount());
        data.put("JdbcResultSetOpenCount", this.getJdbcResultSetOpenCount());
        data.put("JdbcResultSetCloseCount", this.getJdbcResultSetCloseCount());
        data.put("JdbcExecuteCount", this.getJdbcExecuteCount());
        data.put("JdbcExecuteErrorCount", this.getJdbcExecuteErrorCount());
        data.put("JdbcExecuteTimeMillis", this.getJdbcExecuteTimeMillis());
        data.put("JdbcFetchRowCount", this.getJdbcFetchRowCount());
        data.put("JdbcUpdateCount", this.getJdbcUpdateCount());
        data.put("LastError", this.getLastError());
        data.put("LastErrorTime", this.getLastErrorTime());
        return data;
    }
}

