/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.logging;

import com.alibaba.druid.support.logging.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdk14LoggingImpl
implements Log {
    private Logger log;
    private int errorCount;
    private int warnCount;
    private int infoCount;
    private String clazzName;

    public Jdk14LoggingImpl(Class<?> clazz) {
        this.clazzName = clazz.getName();
        this.log = Logger.getLogger(this.clazzName);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
        ++this.errorCount;
    }

    @Override
    public void error(String s) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
        ++this.errorCount;
    }

    @Override
    public void debug(String s) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
    }

    @Override
    public void debug(String s, Throwable e) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
    }

    @Override
    public void warn(String s) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), s);
        ++this.warnCount;
    }

    @Override
    public void warn(String s, Throwable e) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), s, e);
        ++this.warnCount;
    }

    @Override
    public int getWarnCount() {
        return this.warnCount;
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void resetStat() {
        this.errorCount = 0;
        this.warnCount = 0;
        this.infoCount = 0;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), msg);
        ++this.infoCount;
    }

    @Override
    public int getInfoCount() {
        return this.infoCount;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }
}

