/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SQLCaseExpr
extends SQLExprImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Item> items = new ArrayList<Item>();
    private SQLExpr valueExpr;
    private SQLExpr elseExpr;

    @Override
    public void output(StringBuffer buf) {
        buf.append("CASE ");
        if (this.valueExpr != null) {
            this.valueExpr.output(buf);
            buf.append(" ");
        }
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            this.items.get(i).output(buf);
        }
        if (this.elseExpr != null) {
            buf.append(" ELSE ");
            this.elseExpr.output(buf);
        }
        buf.append(" END");
    }

    public SQLExpr getValueExpr() {
        return this.valueExpr;
    }

    public void setValueExpr(SQLExpr valueExpr) {
        this.valueExpr = valueExpr;
    }

    public SQLExpr getElseExpr() {
        return this.elseExpr;
    }

    public void setElseExpr(SQLExpr elseExpr) {
        this.elseExpr = elseExpr;
    }

    public List<Item> getItems() {
        return this.items;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.valueExpr);
            this.acceptChild(visitor, this.items);
            this.acceptChild(visitor, this.elseExpr);
        }
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elseExpr == null ? 0 : this.elseExpr.hashCode());
        result = 31 * result + (this.items == null ? 0 : ((Object)this.items).hashCode());
        result = 31 * result + (this.valueExpr == null ? 0 : this.valueExpr.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLCaseExpr other = (SQLCaseExpr)obj;
        if (this.elseExpr == null ? other.elseExpr != null : !this.elseExpr.equals(other.elseExpr)) {
            return false;
        }
        if (this.items == null ? other.items != null : !((Object)this.items).equals(other.items)) {
            return false;
        }
        return !(this.valueExpr == null ? other.valueExpr != null : !this.valueExpr.equals(other.valueExpr));
    }

    public static class Item
    extends SQLObjectImpl
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private SQLExpr conditionExpr;
        private SQLExpr valueExpr;

        public Item() {
        }

        public Item(SQLExpr conditionExpr, SQLExpr valueExpr) {
            this.conditionExpr = conditionExpr;
            this.valueExpr = valueExpr;
        }

        public SQLExpr getConditionExpr() {
            return this.conditionExpr;
        }

        public void setConditionExpr(SQLExpr conditionExpr) {
            this.conditionExpr = conditionExpr;
        }

        public SQLExpr getValueExpr() {
            return this.valueExpr;
        }

        public void setValueExpr(SQLExpr valueExpr) {
            this.valueExpr = valueExpr;
        }

        @Override
        public void output(StringBuffer buf) {
            buf.append("WHEN ");
            this.conditionExpr.output(buf);
            buf.append(" THEN ");
            this.valueExpr.output(buf);
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.conditionExpr);
                this.acceptChild(visitor, this.valueExpr);
            }
            visitor.endVisit(this);
        }
    }
}

