/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.proxy.jdbc;

import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.StatementExecuteType;
import com.alibaba.druid.proxy.jdbc.StatementProxyImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;

public class PreparedStatementProxyImpl
extends StatementProxyImpl
implements PreparedStatementProxy {
    protected final PreparedStatement statement;
    protected final String sql;
    protected final Map<Integer, JdbcParameter> parameters = new TreeMap<Integer, JdbcParameter>();

    public PreparedStatementProxyImpl(ConnectionProxy connection, PreparedStatement statement, String sql, long id) {
        super(connection, statement, id);
        this.statement = statement;
        this.sql = sql;
    }

    @Override
    public Map<Integer, JdbcParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public PreparedStatement getRawObject() {
        return this.statement;
    }

    @Override
    public void addBatch() throws SQLException {
        this.createChain().preparedStatement_addBatch(this);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.createChain().preparedStatement_clearParameters(this);
    }

    @Override
    public String getBatchSql() {
        return this.sql;
    }

    @Override
    public boolean execute() throws SQLException {
        this.updateCount = null;
        this.lastExecuteType = StatementExecuteType.Execute;
        this.firstResultSet = this.createChain().preparedStatement_execute(this);
        return this.firstResultSet;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.firstResultSet = true;
        this.updateCount = null;
        this.lastExecuteType = StatementExecuteType.ExecuteQuery;
        return this.createChain().preparedStatement_executeQuery(this);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.firstResultSet = false;
        this.lastExecuteType = StatementExecuteType.ExecuteUpdate;
        this.updateCount = this.createChain().preparedStatement_executeUpdate(this);
        return this.updateCount;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.createChain().preparedStatement_getMetaData(this);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.createChain().preparedStatement_getParameterMetaData(this);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2003, x));
        this.createChain().preparedStatement_setArray(this, parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10002, x));
        this.createChain().preparedStatement_setAsciiStream(this, parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10002, (Object)x, length));
        this.createChain().preparedStatement_setAsciiStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10002, (Object)x, length));
        this.createChain().preparedStatement_setAsciiStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(3, x));
        this.createChain().preparedStatement_setBigDecimal(this, parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10001, x));
        this.createChain().preparedStatement_setBinaryStream(this, parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10001, (Object)x, length));
        this.createChain().preparedStatement_setBinaryStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10001, (Object)x, length));
        this.createChain().preparedStatement_setBinaryStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2004, x));
        this.createChain().preparedStatement_setBlob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2004, x));
        this.createChain().preparedStatement_setBlob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2004, (Object)x, length));
        this.createChain().preparedStatement_setBlob(this, parameterIndex, x, length);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(16, x));
        this.createChain().preparedStatement_setBoolean(this, parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(-6, x));
        this.createChain().preparedStatement_setByte(this, parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10007, x));
        this.createChain().preparedStatement_setBytes(this, parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10003, x));
        this.createChain().preparedStatement_setCharacterStream(this, parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10003, (Object)x, length));
        this.createChain().preparedStatement_setCharacterStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10003, (Object)x, length));
        this.createChain().preparedStatement_setCharacterStream((PreparedStatementProxy)this, parameterIndex, x, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2005, x));
        this.createChain().preparedStatement_setClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2005, x));
        this.createChain().preparedStatement_setClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2005, (Object)x, length));
        this.createChain().preparedStatement_setClob(this, parameterIndex, x, length);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(91, x));
        this.createChain().preparedStatement_setDate(this, parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(91, (Object)x, cal));
        this.createChain().preparedStatement_setDate(this, parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(8, x));
        this.createChain().preparedStatement_setDouble(this, parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(6, Float.valueOf(x)));
        this.createChain().preparedStatement_setFloat(this, parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(4, x));
        this.createChain().preparedStatement_setInt(this, parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(-5, x));
        this.createChain().preparedStatement_setLong(this, parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10004, x));
        this.createChain().preparedStatement_setNCharacterStream(this, parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10004, (Object)x, length));
        this.createChain().preparedStatement_setNCharacterStream(this, parameterIndex, x, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2011, x));
        this.createChain().preparedStatement_setNClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2011, x));
        this.createChain().preparedStatement_setNClob((PreparedStatementProxy)this, parameterIndex, x);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2011, (Object)x, length));
        this.createChain().preparedStatement_setNClob(this, parameterIndex, x, length);
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(-9, x));
        this.createChain().preparedStatement_setNString(this, parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(sqlType, null));
        this.createChain().preparedStatement_setNull(this, parameterIndex, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(sqlType, null));
        this.createChain().preparedStatement_setNull(this, parameterIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(1111, null));
        this.createChain().preparedStatement_setObject(this, parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(targetSqlType, x));
        this.createChain().preparedStatement_setObject(this, parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(targetSqlType, x, -1L, null, scaleOrLength));
        this.createChain().preparedStatement_setObject(this, parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2006, x));
        this.createChain().preparedStatement_setRef(this, parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(-8, x));
        this.createChain().preparedStatement_setRowId(this, parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(2009, x));
        this.createChain().preparedStatement_setSQLXML(this, parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(5, x));
        this.createChain().preparedStatement_setShort(this, parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(12, x));
        this.createChain().preparedStatement_setString(this, parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(92, x));
        this.createChain().preparedStatement_setTime(this, parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(92, (Object)x, cal));
        this.createChain().preparedStatement_setTime(this, parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(93, x));
        this.createChain().preparedStatement_setTimestamp(this, parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(93, x));
        this.createChain().preparedStatement_setTimestamp(this, parameterIndex, x, cal);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10005, x));
        this.createChain().preparedStatement_setURL(this, parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, new JdbcParameter(10006, (Object)x, length));
        this.createChain().preparedStatement_setUnicodeStream(this, parameterIndex, x, length);
    }

    public void setParameter(int parameterIndex, JdbcParameter parameter) {
        this.getParameters().put(parameterIndex, parameter);
    }

    @Override
    public String getLastExecuteSql() {
        return this.sql;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == PreparedStatement.class) {
            return (T)this.statement;
        }
        return super.unwrap(iface);
    }
}

