/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.util.IOUtils;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public final class DruidConnectionHolder {
    private final DruidAbstractDataSource dataSource;
    private final Connection conn;
    private final List<ConnectionEventListener> connectionEventListeners;
    private final List<StatementEventListener> statementEventListeners;
    private final long connecttimeMillis;
    private transient long lastActiveTimeMillis;
    private long useCount;
    private PreparedStatementPool statementPool;
    private final List<Statement> statementTrace;
    private final boolean defaultReadOnly;
    private final int defaultHoldability;
    private final int defaultTransactionIsolation;
    private final boolean defaultAutoCommit;
    private boolean underlyingReadOnly;
    private int underlyingHoldability;
    private int underlyingTransactionIsolation;
    private boolean underlyingAutoCommit;

    public DruidConnectionHolder(DruidAbstractDataSource dataSource, Connection conn) throws SQLException {
        block2: {
            this.connectionEventListeners = new CopyOnWriteArrayList<ConnectionEventListener>();
            this.statementEventListeners = new CopyOnWriteArrayList<StatementEventListener>();
            this.useCount = 0L;
            this.statementTrace = new ArrayList<Statement>();
            this.dataSource = dataSource;
            this.conn = conn;
            this.lastActiveTimeMillis = this.connecttimeMillis = System.currentTimeMillis();
            this.underlyingAutoCommit = conn.getAutoCommit();
            this.underlyingHoldability = conn.getHoldability();
            this.underlyingReadOnly = conn.isReadOnly();
            try {
                this.underlyingTransactionIsolation = conn.getTransactionIsolation();
            }
            catch (SQLException e) {
                if ("com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException".equals(e.getClass().getName())) break block2;
                throw e;
            }
        }
        this.defaultHoldability = this.underlyingHoldability;
        this.defaultTransactionIsolation = this.underlyingTransactionIsolation;
        this.defaultAutoCommit = this.underlyingAutoCommit;
        this.defaultReadOnly = this.underlyingReadOnly;
    }

    public boolean isUnderlyingReadOnly() {
        return this.underlyingReadOnly;
    }

    public void setUnderlyingReadOnly(boolean underlyingReadOnly) {
        this.underlyingReadOnly = underlyingReadOnly;
    }

    public int getUnderlyingHoldability() {
        return this.underlyingHoldability;
    }

    public void setUnderlyingHoldability(int underlyingHoldability) {
        this.underlyingHoldability = underlyingHoldability;
    }

    public int getUnderlyingTransactionIsolation() {
        return this.underlyingTransactionIsolation;
    }

    public void setUnderlyingTransactionIsolation(int underlyingTransactionIsolation) {
        this.underlyingTransactionIsolation = underlyingTransactionIsolation;
    }

    public boolean isUnderlyingAutoCommit() {
        return this.underlyingAutoCommit;
    }

    public void setUnderlyingAutoCommit(boolean underlyingAutoCommit) {
        this.underlyingAutoCommit = underlyingAutoCommit;
    }

    public long getLastActiveTimeMillis() {
        return this.lastActiveTimeMillis;
    }

    public void setLastActiveTimeMillis(long lastActiveMillis) {
        this.lastActiveTimeMillis = lastActiveMillis;
    }

    public void addTrace(DruidPooledStatement stmt) {
        this.statementTrace.add(stmt);
    }

    public void removeTrace(DruidPooledStatement stmt) {
        this.statementTrace.remove(stmt);
    }

    public List<ConnectionEventListener> getConnectionEventListeners() {
        return this.connectionEventListeners;
    }

    public List<StatementEventListener> getStatementEventListeners() {
        return this.statementEventListeners;
    }

    public PreparedStatementPool getStatementPool() {
        if (this.statementPool == null) {
            this.statementPool = new PreparedStatementPool(this);
        }
        return this.statementPool;
    }

    public DruidAbstractDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPoolPreparedStatements() {
        return this.dataSource.isPoolPreparedStatements();
    }

    public Connection getConnection() {
        return this.conn;
    }

    public long getTimeMillis() {
        return this.connecttimeMillis;
    }

    public long getUseCount() {
        return this.useCount;
    }

    public void incrementUseCount() {
        ++this.useCount;
    }

    public void reset() throws SQLException {
        if (this.underlyingReadOnly != this.defaultReadOnly) {
            this.conn.setReadOnly(this.defaultReadOnly);
        }
        if (this.underlyingHoldability != this.defaultHoldability) {
            this.conn.setHoldability(this.defaultHoldability);
        }
        if (this.underlyingTransactionIsolation != this.defaultTransactionIsolation) {
            this.conn.setTransactionIsolation(this.defaultTransactionIsolation);
        }
        if (this.underlyingAutoCommit != this.defaultAutoCommit) {
            this.conn.setAutoCommit(this.defaultAutoCommit);
        }
        this.connectionEventListeners.clear();
        this.statementEventListeners.clear();
        for (Object item : this.statementTrace.toArray()) {
            Statement stmt = (Statement)item;
            JdbcUtils.close(stmt);
        }
        this.statementTrace.clear();
        this.conn.clearWarnings();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ID:");
        buf.append(System.identityHashCode(this.conn));
        buf.append(", ConnectTime:\"");
        buf.append(IOUtils.toString(new Date(this.connecttimeMillis)));
        buf.append("\", UseCount:");
        buf.append(this.useCount);
        if (this.lastActiveTimeMillis > 0L) {
            buf.append(", LastActiveTime:\"");
            buf.append(IOUtils.toString(new Date(this.lastActiveTimeMillis)));
            buf.append("\"");
        }
        if (this.statementPool != null && this.statementPool.getMap().size() > 0) {
            buf.append("\", CachedStatementCount:");
            buf.append(this.statementPool.getMap().size());
        }
        buf.append("}");
        return buf.toString();
    }
}

