/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall.spi;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlReplaceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallProvider;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import java.util.ArrayList;
import java.util.List;

public class OracleWallVisitor
extends OracleASTVisitorAdapter
implements WallVisitor {
    private final WallConfig config;
    private final WallProvider provider;
    private final List<Violation> violations = new ArrayList<Violation>();

    public OracleWallVisitor(WallProvider provider) {
        this.config = provider.getConfig();
        this.provider = provider;
    }

    @Override
    public WallProvider getProvider() {
        return this.provider;
    }

    @Override
    public WallConfig getConfig() {
        return this.config;
    }

    @Override
    public void addViolation(Violation violation) {
        this.violations.add(violation);
    }

    @Override
    public List<Violation> getViolations() {
        return this.violations;
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        name = WallVisitorUtils.form(name);
        if (this.config.isVariantCheck() && this.config.getDenyVariants().contains(name)) {
            this.getViolations().add(new IllegalSQLObjectViolation(2003, "variable not allow : " + name, this.toSQL(x)));
        }
        return true;
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLInListExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLMethodInvokeExpr x) {
        WallVisitorUtils.checkFunction(this, x);
        return true;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        return WallVisitorUtils.check((WallVisitor)this, x);
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return !(x.getExpr() instanceof SQLName);
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        WallVisitorUtils.checkHaving(this, x.getHaving());
        return true;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock x) {
        WallVisitorUtils.checkSelelct(this, x);
        return true;
    }

    @Override
    public boolean visit(OracleSelectQueryBlock x) {
        WallVisitorUtils.checkSelelct(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        WallVisitorUtils.checkUnion(this, x);
        return true;
    }

    @Override
    public String toSQL(SQLObject obj) {
        return SQLUtils.toOracleString(obj);
    }

    @Override
    public boolean isDenyTable(String name) {
        if (!this.config.isTableCheck()) {
            return false;
        }
        if ((name = WallVisitorUtils.form(name)).startsWith("v$") || name.startsWith("v_$")) {
            return true;
        }
        return !this.provider.checkDenyTable(name);
    }

    @Override
    public void preVisit(SQLObject x) {
        WallVisitorUtils.preVisitCheck(this, x);
    }

    @Override
    public boolean visit(SQLSelectStatement x) {
        if (!this.config.isSelelctAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(1002, "select not allow", this.toSQL(x)));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(OracleInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public boolean visit(SQLInsertStatement x) {
        WallVisitorUtils.checkInsert(this, x);
        return true;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
        WallVisitorUtils.checkInsert(this, x);
        return true;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement x) {
        if (!this.config.isInsertAllow()) {
            this.getViolations().add(new IllegalSQLObjectViolation(1004, "insert not allow", this.toSQL(x)));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(OracleDeleteStatement x) {
        return this.visit((SQLDeleteStatement)x);
    }

    @Override
    public boolean visit(SQLDeleteStatement x) {
        WallVisitorUtils.checkDelete(this, x);
        return true;
    }

    @Override
    public boolean visit(OracleUpdateStatement x) {
        return this.visit((SQLUpdateStatement)x);
    }

    @Override
    public boolean visit(SQLUpdateStatement x) {
        WallVisitorUtils.checkUpdate(this, x);
        return true;
    }

    @Override
    public boolean visit(SQLSelectItem x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLCreateTableStatement x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(OracleCreateTableStatement x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(OracleAlterTableStatement x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLDropTableStatement x) {
        WallVisitorUtils.check((WallVisitor)this, x);
        return true;
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        return false;
    }

    public boolean visit(MySqlReplaceStatement x) {
        return true;
    }

    @Override
    public boolean visit(SQLCallStatement x) {
        return false;
    }
}

