/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.wall;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.NotAllowCommentException;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.ExportParameterVisitor;
import com.alibaba.druid.util.LRUCache;
import com.alibaba.druid.wall.Violation;
import com.alibaba.druid.wall.WallCheckResult;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallContext;
import com.alibaba.druid.wall.WallDenyStat;
import com.alibaba.druid.wall.WallFunctionStat;
import com.alibaba.druid.wall.WallSqlFunctionStat;
import com.alibaba.druid.wall.WallSqlStat;
import com.alibaba.druid.wall.WallSqlTableStat;
import com.alibaba.druid.wall.WallTableStat;
import com.alibaba.druid.wall.WallVisitor;
import com.alibaba.druid.wall.spi.WallVisitorUtils;
import com.alibaba.druid.wall.violation.IllegalSQLObjectViolation;
import com.alibaba.druid.wall.violation.SyntaxErrorViolation;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class WallProvider {
    private LRUCache<String, WallSqlStat> whiteList;
    private int MAX_SQL_LENGTH = 2048;
    private int whiteSqlMaxSize = 500;
    private LRUCache<String, WallSqlStat> blackList;
    private int blackSqlMaxSize = 100;
    protected final WallConfig config;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final ThreadLocal<Boolean> privileged = new ThreadLocal();
    private final ConcurrentMap<String, WallFunctionStat> functionStats = new ConcurrentHashMap<String, WallFunctionStat>();
    private final ConcurrentMap<String, WallTableStat> tableStats = new ConcurrentHashMap<String, WallTableStat>();
    public final WallDenyStat commentDeniedStat = new WallDenyStat();
    protected String dbType = null;
    protected final AtomicLong checkCount = new AtomicLong();
    protected final AtomicLong hardCheckCount = new AtomicLong();
    protected final AtomicLong whiteListHitCount = new AtomicLong();
    protected final AtomicLong blackListHitCount = new AtomicLong();
    protected final AtomicLong syntaxErrrorCount = new AtomicLong();
    protected final AtomicLong violationCount = new AtomicLong();
    protected final AtomicLong violationEffectRowCount = new AtomicLong();
    private static final ThreadLocal<Object> tenantValueLocal = new ThreadLocal();

    public WallProvider(WallConfig config) {
        this.config = config;
    }

    public WallProvider(WallConfig config, String dbType) {
        this.config = config;
        this.dbType = dbType;
    }

    public void reset() {
        this.checkCount.set(0L);
        this.hardCheckCount.set(0L);
        this.violationCount.set(0L);
        this.whiteListHitCount.set(0L);
        this.blackListHitCount.set(0L);
        this.clearWhiteList();
        this.clearBlackList();
        this.functionStats.clear();
        this.tableStats.clear();
    }

    public ConcurrentMap<String, WallTableStat> getTableStats() {
        return this.tableStats;
    }

    public ConcurrentMap<String, WallFunctionStat> getFunctionStats() {
        return this.functionStats;
    }

    public WallTableStat getTableStat(String tableName) {
        String lowerCaseName = tableName.toLowerCase();
        if (lowerCaseName.startsWith("`") && lowerCaseName.endsWith("`")) {
            lowerCaseName = lowerCaseName.substring(1, lowerCaseName.length() - 1);
        }
        return this.getTableStatWithLowerName(lowerCaseName);
    }

    public WallTableStat getTableStatWithLowerName(String lowerCaseName) {
        WallTableStat stat = (WallTableStat)this.tableStats.get(lowerCaseName);
        if (stat == null) {
            if (this.tableStats.size() > 10000) {
                return null;
            }
            this.tableStats.putIfAbsent(lowerCaseName, new WallTableStat());
            stat = (WallTableStat)this.tableStats.get(lowerCaseName);
        }
        return stat;
    }

    public WallFunctionStat getFunctionStat(String functionName) {
        String lowerCaseName = functionName.toLowerCase();
        return this.getFunctionStatWithLowerName(lowerCaseName);
    }

    public WallFunctionStat getFunctionStatWithLowerName(String lowerCaseName) {
        WallFunctionStat stat = (WallFunctionStat)this.functionStats.get(lowerCaseName);
        if (stat == null) {
            if (this.functionStats.size() > 10000) {
                return null;
            }
            this.functionStats.putIfAbsent(lowerCaseName, new WallFunctionStat());
            stat = (WallFunctionStat)this.functionStats.get(lowerCaseName);
        }
        return stat;
    }

    public WallConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat addWhiteSql(String sql, Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats, boolean syntaxError) {
        this.lock.writeLock().lock();
        try {
            WallSqlStat wallStat;
            if (this.whiteList == null) {
                this.whiteList = new LRUCache(this.whiteSqlMaxSize);
            }
            if ((wallStat = (WallSqlStat)this.whiteList.get(sql)) == null) {
                wallStat = new WallSqlStat(tableStats, functionStats, syntaxError);
                wallStat.incrementAndGetExecuteCount();
                this.whiteList.put(sql, wallStat);
            }
            WallSqlStat wallSqlStat = wallStat;
            return wallSqlStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat addBlackSql(String sql, Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats, List<Violation> violations, boolean syntaxError) {
        this.lock.writeLock().lock();
        try {
            WallSqlStat wallStat;
            if (this.blackList == null) {
                this.blackList = new LRUCache(this.blackSqlMaxSize);
            }
            if ((wallStat = (WallSqlStat)this.blackList.get(sql)) == null) {
                wallStat = new WallSqlStat(tableStats, functionStats, violations, syntaxError);
                wallStat.incrementAndGetExecuteCount();
                this.blackList.put(sql, wallStat);
            }
            WallSqlStat wallSqlStat = wallStat;
            return wallSqlStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWhiteList() {
        HashSet hashSet = new HashSet();
        this.lock.readLock().lock();
        try {
            if (this.whiteList != null) {
                hashSet.addAll(this.whiteList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBlackList() {
        HashSet hashSet = new HashSet();
        this.lock.readLock().lock();
        try {
            if (this.blackList != null) {
                hashSet.addAll(this.blackList.keySet());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return Collections.unmodifiableSet(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getBlackListStat() {
        ArrayList<Map<String, Object>> map = new ArrayList<Map<String, Object>>();
        this.lock.readLock().lock();
        try {
            if (this.blackList != null) {
                for (Map.Entry entry : this.blackList.entrySet()) {
                    WallSqlStat sqlStat = (WallSqlStat)entry.getValue();
                    LinkedHashMap<String, Object> sqlStatMap = new LinkedHashMap<String, Object>();
                    sqlStatMap.put("sql", entry.getKey());
                    sqlStatMap.put("executeCount", sqlStat.getExecuteCount());
                    sqlStatMap.put("effectRowCount", sqlStat.getEffectRowCount());
                    List<Violation> violations = sqlStat.getViolations();
                    if (violations.size() > 0) {
                        sqlStatMap.put("violationMessage", violations.get(0).getMessage());
                    }
                    map.add(sqlStatMap);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return map;
    }

    public void clearCache() {
        this.clearWhiteList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWhiteList() {
        this.lock.writeLock().lock();
        try {
            if (this.whiteList != null) {
                this.whiteList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlackList() {
        this.lock.writeLock().lock();
        try {
            if (this.blackList != null) {
                this.blackList = null;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat getWhiteSql(String sql) {
        this.lock.readLock().lock();
        try {
            if (this.whiteList == null) {
                WallSqlStat wallSqlStat = null;
                return wallSqlStat;
            }
            WallSqlStat wallSqlStat = (WallSqlStat)this.whiteList.get(sql);
            return wallSqlStat;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallSqlStat getBlackSql(String sql) {
        this.lock.readLock().lock();
        try {
            if (this.blackList == null) {
                WallSqlStat wallSqlStat = null;
                return wallSqlStat;
            }
            WallSqlStat wallSqlStat = (WallSqlStat)this.blackList.get(sql);
            return wallSqlStat;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean whiteContains(String sql) {
        return this.getWhiteSql(sql) != null;
    }

    public abstract SQLStatementParser createParser(String var1);

    public abstract WallVisitor createWallVisitor();

    public abstract ExportParameterVisitor createExportParameterVisitor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid(String sql) {
        WallContext originalContext = WallContext.current();
        try {
            WallContext.create(this.dbType);
            WallCheckResult result = this.checkInternal(sql);
            boolean bl = result.getViolations().isEmpty();
            return bl;
        }
        finally {
            if (originalContext == null) {
                WallContext.clearContext();
            }
        }
    }

    public void incrementCommentDeniedCount() {
        this.commentDeniedStat.incrementAndGetDenyCount();
    }

    public boolean checkDenyFunction(String functionName) {
        if (functionName == null) {
            return true;
        }
        functionName = functionName.toLowerCase();
        return !this.getConfig().getDenyFunctions().contains(functionName);
    }

    public boolean checkDenySchema(String schemaName) {
        if (schemaName == null) {
            return true;
        }
        if (!this.config.isSchemaCheck()) {
            return true;
        }
        schemaName = schemaName.toLowerCase();
        return !this.getConfig().getDenySchemas().contains(schemaName);
    }

    public boolean checkDenyTable(String tableName) {
        if (tableName == null) {
            return true;
        }
        tableName = WallVisitorUtils.form(tableName);
        return !this.getConfig().getDenyTables().contains(tableName);
    }

    public boolean checkReadOnlyTable(String tableName) {
        if (tableName == null) {
            return true;
        }
        tableName = WallVisitorUtils.form(tableName);
        return !this.getConfig().isReadOnly(tableName);
    }

    public WallDenyStat getCommentDenyStat() {
        return this.commentDeniedStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WallCheckResult check(String sql) {
        WallContext originalContext = WallContext.current();
        try {
            WallContext.createIfNotExists(this.dbType);
            WallCheckResult wallCheckResult = this.checkInternal(sql);
            return wallCheckResult;
        }
        finally {
            if (originalContext == null) {
                WallContext.clearContext();
            }
        }
    }

    private WallCheckResult checkInternal(String sql) {
        WallCheckResult checkResult;
        boolean mulltiTenant;
        this.checkCount.incrementAndGet();
        WallContext context = WallContext.current();
        if (this.config.isDoPrivilegedAllow() && WallProvider.ispPivileged()) {
            return new WallCheckResult();
        }
        boolean bl = mulltiTenant = this.config.getTenantTablePattern() != null && this.config.getTenantTablePattern().length() > 0;
        if (!mulltiTenant && (checkResult = this.checkWhiteAndBlackList(sql)) != null) {
            return checkResult;
        }
        this.hardCheckCount.incrementAndGet();
        ArrayList<Violation> violations = new ArrayList<Violation>();
        ArrayList<SQLStatement> statementList = new ArrayList<SQLStatement>();
        boolean syntaxError = false;
        try {
            SQLStatementParser parser = this.createParser(sql);
            parser.getLexer().setCommentHandler(WallCommentHandler.instance);
            if (!this.config.isCommentAllow()) {
                parser.getLexer().setAllowComment(false);
            }
            parser.parseStatementList(statementList);
            Token lastToken = parser.getLexer().token();
            if (lastToken != Token.EOF) {
                violations.add(new IllegalSQLObjectViolation(1001, "not terminal sql, token " + (Object)((Object)lastToken), sql));
            }
        }
        catch (NotAllowCommentException e) {
            violations.add(new SyntaxErrorViolation(e, sql));
            this.incrementCommentDeniedCount();
        }
        catch (ParserException e) {
            this.syntaxErrrorCount.incrementAndGet();
            syntaxError = true;
            if (this.config.isStrictSyntaxCheck()) {
                violations.add(new SyntaxErrorViolation(e, sql));
            }
        }
        catch (Exception e) {
            violations.add(new SyntaxErrorViolation(e, sql));
        }
        if (statementList.size() > 1 && !this.config.isMultiStatementAllow()) {
            violations.add(new IllegalSQLObjectViolation(2201, "multi-statement not allow", sql));
        }
        WallVisitor visitor = this.createWallVisitor();
        if (statementList.size() > 0) {
            SQLStatement stmt = (SQLStatement)statementList.get(0);
            try {
                stmt.accept(visitor);
            }
            catch (ParserException e) {
                violations.add(new SyntaxErrorViolation(e, sql));
            }
        }
        if (visitor.getViolations().size() > 0) {
            violations.addAll(visitor.getViolations());
        }
        if (visitor.getViolations().size() == 0 && context != null && context.getWarnnings() >= 2) {
            if (context.getDeleteNoneConditionWarnnings() > 0) {
                violations.add(new IllegalSQLObjectViolation(2104, "delete none condition", sql));
            } else if (context.getUpdateNoneConditionWarnnings() > 0) {
                violations.add(new IllegalSQLObjectViolation(2104, "update none condition", sql));
            } else if (context.getCommentCount() > 0) {
                violations.add(new IllegalSQLObjectViolation(1301, "comment not allow", sql));
            } else if (context.getLikeNumberWarnnings() > 0) {
                violations.add(new IllegalSQLObjectViolation(1301, "like number", sql));
            } else {
                violations.add(new IllegalSQLObjectViolation(8000, "multi-warnnings", sql));
            }
        }
        WallSqlStat sqlStat = null;
        if (violations.size() > 0) {
            this.violationCount.incrementAndGet();
            if (sql.length() < this.MAX_SQL_LENGTH) {
                sqlStat = this.addBlackSql(sql, context.getTableStats(), context.getFunctionStats(), violations, syntaxError);
            }
        } else if (sql.length() < this.MAX_SQL_LENGTH) {
            sqlStat = this.addWhiteSql(sql, context.getTableStats(), context.getFunctionStats(), syntaxError);
        }
        Map<String, WallSqlTableStat> tableStats = null;
        Map<String, WallSqlFunctionStat> functionStats = null;
        if (context != null) {
            tableStats = context.getTableStats();
            functionStats = context.getFunctionStats();
            this.recordStats(tableStats, functionStats);
        }
        if (sqlStat != null) {
            context.setSqlStat(sqlStat);
            return new WallCheckResult(sqlStat, statementList);
        }
        return new WallCheckResult(sqlStat, violations, tableStats, functionStats, statementList, syntaxError);
    }

    private WallCheckResult checkWhiteAndBlackList(String sql) {
        WallSqlStat sqlStat = this.getWhiteSql(sql);
        if (sqlStat != null) {
            this.whiteListHitCount.incrementAndGet();
            sqlStat.incrementAndGetExecuteCount();
            if (sqlStat.isSyntaxError()) {
                this.syntaxErrrorCount.incrementAndGet();
            }
            this.recordStats(sqlStat.getTableStats(), sqlStat.getFunctionStats());
            WallContext context = WallContext.current();
            if (context != null) {
                context.setSqlStat(sqlStat);
            }
            return new WallCheckResult(sqlStat);
        }
        sqlStat = this.getBlackSql(sql);
        if (sqlStat != null) {
            this.blackListHitCount.incrementAndGet();
            this.violationCount.incrementAndGet();
            if (sqlStat.isSyntaxError()) {
                this.syntaxErrrorCount.incrementAndGet();
            }
            sqlStat.incrementAndGetExecuteCount();
            this.recordStats(sqlStat.getTableStats(), sqlStat.getFunctionStats());
            return new WallCheckResult(sqlStat);
        }
        return null;
    }

    void recordStats(Map<String, WallSqlTableStat> tableStats, Map<String, WallSqlFunctionStat> functionStats) {
        Object sqlTableStat;
        String tableName;
        if (tableStats != null) {
            for (Map.Entry<String, Object> entry : tableStats.entrySet()) {
                tableName = entry.getKey();
                sqlTableStat = (WallSqlTableStat)entry.getValue();
                WallTableStat tableStat = this.getTableStat(tableName);
                if (tableStat == null) continue;
                tableStat.addSqlTableStat((WallSqlTableStat)sqlTableStat);
            }
        }
        if (functionStats != null) {
            for (Map.Entry<String, Object> entry : functionStats.entrySet()) {
                tableName = entry.getKey();
                sqlTableStat = (WallSqlFunctionStat)entry.getValue();
                WallFunctionStat functionStat = this.getFunctionStatWithLowerName(tableName);
                if (functionStat == null) continue;
                functionStat.addSqlFunctionStat((WallSqlFunctionStat)sqlTableStat);
            }
        }
    }

    public static boolean ispPivileged() {
        Boolean value = privileged.get();
        if (value == null) {
            return false;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        privileged.set(Boolean.TRUE);
        try {
            T t = action.run();
            return t;
        }
        finally {
            privileged.set(null);
        }
    }

    public static void setTenantValue(Object value) {
        tenantValueLocal.set(value);
    }

    public static Object getTenantValue() {
        return tenantValueLocal.get();
    }

    public long getWhiteListHitCount() {
        return this.whiteListHitCount.get();
    }

    public long getBlackListHitCount() {
        return this.blackListHitCount.get();
    }

    public long getSyntaxErrorCount() {
        return this.syntaxErrrorCount.get();
    }

    public long getCheckCount() {
        return this.checkCount.get();
    }

    public long getViolationCount() {
        return this.violationCount.get();
    }

    public long getHardCheckCount() {
        return this.hardCheckCount.get();
    }

    public long getViolationEffectRowCount() {
        return this.violationEffectRowCount.get();
    }

    public void addViolationEffectRowCount(long rowCount) {
        this.violationEffectRowCount.addAndGet(rowCount);
    }

    public Map<String, Object> getStatsMap() {
        Map<String, Object> statMap;
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("checkCount", this.getCheckCount());
        info.put("hardCheckCount", this.getHardCheckCount());
        info.put("violationCount", this.getViolationCount());
        info.put("violationEffectRowCount", this.getViolationEffectRowCount());
        info.put("blackListHitCount", this.getBlackListHitCount());
        info.put("blackListSize", this.getBlackList().size());
        info.put("whiteListHitCount", this.getWhiteListHitCount());
        info.put("whiteListSize", this.getWhiteList().size());
        info.put("syntaxErrrorCount", this.getSyntaxErrorCount());
        ArrayList<Map<String, Object>> tables = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : this.tableStats.entrySet()) {
            statMap = ((WallTableStat)entry.getValue()).toMap();
            statMap.put("name", entry.getKey());
            tables.add(statMap);
        }
        info.put("tables", tables);
        ArrayList<Map<String, Object>> functions = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : this.functionStats.entrySet()) {
            statMap = ((WallFunctionStat)entry.getValue()).toMap();
            statMap.put("name", entry.getKey());
            functions.add(statMap);
        }
        info.put("functions", functions);
        info.put("blackList", this.getBlackListStat());
        return info;
    }

    public static class WallCommentHandler
    implements Lexer.CommentHandler {
        public static final WallCommentHandler instance = new WallCommentHandler();

        @Override
        public boolean handle(Token lastToken, String comment) {
            if (lastToken == null) {
                return false;
            }
            switch (lastToken) {
                case SELECT: 
                case INSERT: 
                case DELETE: 
                case UPDATE: 
                case TRUNCATE: 
                case SET: 
                case CREATE: 
                case ALTER: 
                case DROP: 
                case SHOW: 
                case REPLACE: {
                    return true;
                }
            }
            WallContext context = WallContext.current();
            if (context != null) {
                context.incrementCommentCount();
            }
            return false;
        }
    }
}

