/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public abstract class LazyCompositeData
implements CompositeData,
Serializable {
    private CompositeData compositeData;

    @Override
    public boolean containsKey(String key) {
        return this.compositeData().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.compositeData().containsValue(value);
    }

    @Override
    public boolean equals(Object obj) {
        return this.compositeData().equals(obj);
    }

    @Override
    public Object get(String key) {
        return this.compositeData().get(key);
    }

    @Override
    public Object[] getAll(String[] keys) {
        return this.compositeData().getAll(keys);
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeData().getCompositeType();
    }

    @Override
    public int hashCode() {
        return this.compositeData().hashCode();
    }

    @Override
    public String toString() {
        return this.compositeData().toString();
    }

    @Override
    public Collection<?> values() {
        return this.compositeData().values();
    }

    private synchronized CompositeData compositeData() {
        if (this.compositeData != null) {
            return this.compositeData;
        }
        this.compositeData = this.getCompositeData();
        return this.compositeData;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return this.compositeData();
    }

    protected abstract CompositeData getCompositeData();

    static String getString(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (String)cd.get(itemName);
    }

    static boolean getBoolean(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return (Boolean)cd.get(itemName);
    }

    static long getLong(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return ((Number)cd.get(itemName)).longValue();
    }

    static int getInt(CompositeData cd, String itemName) {
        if (cd == null) {
            throw new IllegalArgumentException("Null CompositeData");
        }
        return ((Number)cd.get(itemName)).intValue();
    }

    protected static boolean isTypeMatched(CompositeType type1, CompositeType type2) {
        if (type1 == type2) {
            return true;
        }
        Set<String> allItems = type1.keySet();
        if (!type2.keySet().containsAll(allItems)) {
            return false;
        }
        for (String item : allItems) {
            OpenType<?> ot1 = type1.getType(item);
            OpenType<?> ot2 = type2.getType(item);
            if (ot1 instanceof CompositeType) {
                if (!(ot2 instanceof CompositeType)) {
                    return false;
                }
                if (LazyCompositeData.isTypeMatched((CompositeType)ot1, (CompositeType)ot2)) continue;
                return false;
            }
            if (ot1 instanceof TabularType) {
                if (!(ot2 instanceof TabularType)) {
                    return false;
                }
                if (LazyCompositeData.isTypeMatched((TabularType)ot1, (TabularType)ot2)) continue;
                return false;
            }
            if (ot1.equals(ot2)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isTypeMatched(TabularType type1, TabularType type2) {
        List<String> list2;
        if (type1 == type2) {
            return true;
        }
        List<String> list1 = type1.getIndexNames();
        if (!list1.equals(list2 = type2.getIndexNames())) {
            return false;
        }
        return LazyCompositeData.isTypeMatched(type1.getRowType(), type2.getRowType());
    }
}

