/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import com.addthis.metrics.reporter.config.HostPort;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GmondConfigParser {
    private static final Logger log = LoggerFactory.getLogger(GmondConfigParser.class);
    private static final String C_COMMENT_PATTERN = "//.*?\n";
    private static final String CPP_COMMENT_PATTERN = "(?s)//*.*?/*/";
    private static final String EMPTY_LINE_PATTERN = "(?m)^\\s*\n";
    private static final String UDP_SEND_PATTERN = "(?s)udp_send_channel\\s*\\{(.*?)\\}";

    public List<HostPort> getGmondSendChannels(String fileName) {
        try {
            String conf = this.readFile(fileName);
            return this.getGmondSendChannelsFromConf(conf);
        }
        catch (IOException ioe) {
            log.error("Unable to read gmond config from:" + fileName, (Throwable)ioe);
            return null;
        }
        catch (Exception e) {
            log.error("Error searching for unicast udp_send_channels.  It is possible none are defined in " + fileName, (Throwable)e);
            return null;
        }
    }

    public List<HostPort> getGmondSendChannelsFromConf(String conf) {
        String cleanConf = this.removeEmptyLines(this.stripComments(conf));
        List<String> blobs = this.findSendChannels(cleanConf);
        log.debug("Found {} channels", (Object)blobs.size());
        ArrayList<HostPort> hosts = new ArrayList<HostPort>();
        for (String blob : blobs) {
            Map<String, String> chanMap = this.mapifyChannelString(blob);
            log.debug("Parsed channel from config {}", chanMap);
            HostPort hp = this.makeHostPort(chanMap);
            if (hp != null) {
                hosts.add(hp);
                continue;
            }
            log.warn("Failure to create HostPort from {}", (Object)blob);
        }
        return hosts;
    }

    public String stripComments(String conf) {
        String cFree = conf.replaceAll(C_COMMENT_PATTERN, "\n");
        return cFree.replaceAll(CPP_COMMENT_PATTERN, "");
    }

    public String removeEmptyLines(String conf) {
        return conf.replaceAll(EMPTY_LINE_PATTERN, "");
    }

    public List<String> findSendChannels(String conf) {
        ArrayList<String> channelBlobs = new ArrayList<String>();
        Matcher matcher = Pattern.compile(UDP_SEND_PATTERN).matcher(conf);
        while (matcher.find()) {
            channelBlobs.add(matcher.group(1).trim());
        }
        return channelBlobs;
    }

    public Map<String, String> mapifyChannelString(String sChannel) {
        String[] arr = sChannel.split("\n");
        HashMap<String, String> chan = new HashMap<String, String>();
        for (int i = 0; i < arr.length; ++i) {
            String[] pair = arr[i].split("=");
            chan.put(pair[0].trim(), pair[1].trim().replaceAll("\"", ""));
        }
        return chan;
    }

    public HostPort makeHostPort(Map<String, String> chan) {
        if (chan.containsKey("mcast_join") || chan.containsKey("mcast_if")) {
            log.warn("Looks like a multicast send channel, not supported and ignoring: {}", chan);
            return null;
        }
        HostPort hp = null;
        try {
            hp = new HostPort(chan.get("host"), Integer.valueOf(chan.get("port")));
        }
        catch (Exception e) {
            log.warn("Failed to create HostPort for:" + chan, (Throwable)e);
        }
        return hp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String fileName) throws IOException {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(fileName);
            br = new BufferedReader(fr);
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }
}

