/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.audience;

import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.audience.AudienceType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;

public class Audience
implements PushModel {
    private static final String ALL = "all";
    private final boolean all;
    private final ImmutableSet<AudienceTarget> targets;

    private Audience(boolean all, ImmutableSet<AudienceTarget> targets) {
        this.all = all;
        this.targets = targets;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Audience all() {
        return Audience.newBuilder().setAll(true).build();
    }

    public static Audience tag(String ... tagValue) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG).addAudienceTargetValues(tagValue).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag(Collection<String> tagValues) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG).addAudienceTargetValues(tagValues).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag_and(String ... tagValue) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG_AND).addAudienceTargetValues(tagValue).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience tag_and(Collection<String> tagValues) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.TAG_AND).addAudienceTargetValues(tagValues).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience alias(String ... alias) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.ALIAS).addAudienceTargetValues(alias).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience alias(Collection<String> aliases) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.ALIAS).addAudienceTargetValues(aliases).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience segment(String ... segment) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.SEGMENT).addAudienceTargetValues(segment).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience segment(Collection<String> segments) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.SEGMENT).addAudienceTargetValues(segments).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience registrationId(String ... registrationId) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.REGISTRATION_ID).addAudienceTargetValues(registrationId).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public static Audience registrationId(Collection<String> registrationIds) {
        AudienceTarget target = AudienceTarget.newBuilder().setAudienceType(AudienceType.REGISTRATION_ID).addAudienceTargetValues(registrationIds).build();
        return Audience.newBuilder().addAudienceTarget(target).build();
    }

    public boolean isAll() {
        return this.all;
    }

    @Override
    public JsonElement toJSON() {
        if (this.all) {
            return new JsonPrimitive(ALL);
        }
        JsonObject json = new JsonObject();
        for (AudienceTarget target : this.targets) {
            json.add(target.getAudienceTypeValue(), target.toJSON());
        }
        return json;
    }

    public static class Builder {
        private boolean all = false;
        private ImmutableSet.Builder<AudienceTarget> audienceBuilder = null;

        public Builder setAll(boolean all) {
            this.all = all;
            return this;
        }

        public Builder addAudienceTarget(AudienceTarget target) {
            if (null == this.audienceBuilder) {
                this.audienceBuilder = ImmutableSet.builder();
            }
            this.audienceBuilder.add((Object)target);
            return this;
        }

        public Audience build() {
            Preconditions.checkArgument((!this.all || null == this.audienceBuilder ? 1 : 0) != 0, (Object)"If audience is all, no any other audience may be set.");
            Preconditions.checkArgument((this.all || null != this.audienceBuilder ? 1 : 0) != 0, (Object)"No any audience target is set.");
            return new Audience(this.all, null == this.audienceBuilder ? null : this.audienceBuilder.build());
        }
    }
}

