/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push;

import cn.jpush.api.common.APIConnectionException;
import cn.jpush.api.common.APIRequestException;
import cn.jpush.api.common.HttpProxy;
import cn.jpush.api.common.NativeHttpClient;
import cn.jpush.api.common.ResponseWrapper;
import cn.jpush.api.common.ServiceHelper;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.utils.StringUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

public class PushClient {
    public static final String HOST_NAME_SSL = "https://api.jpush.cn";
    public static final String PUSH_PATH = "/v3/push";
    private final NativeHttpClient _httpClient;
    private JsonParser _jsonParser = new JsonParser();
    private boolean _apnsProduction = true;
    private long _timeToLive = 86400L;
    private boolean _globalSettingEnabled = false;
    private String _baseUrl;

    public PushClient(String masterSecret, String appKey) {
        this(masterSecret, appKey, 3);
    }

    public PushClient(String masterSecret, String appKey, int maxRetryTimes) {
        this(masterSecret, appKey, maxRetryTimes, null);
    }

    public PushClient(String masterSecret, String appKey, int maxRetryTimes, HttpProxy proxy) {
        ServiceHelper.checkBasic(appKey, masterSecret);
        String authCode = ServiceHelper.getBasicAuthorization(appKey, masterSecret);
        this._baseUrl = "https://api.jpush.cn/v3/push";
        this._httpClient = new NativeHttpClient(authCode, maxRetryTimes, proxy);
    }

    public PushClient(String masterSecret, String appKey, boolean apnsProduction, long timeToLive) {
        this(masterSecret, appKey);
        this._apnsProduction = apnsProduction;
        this._timeToLive = timeToLive;
        this._globalSettingEnabled = true;
    }

    public void setDefaults(boolean apnsProduction, long timeToLive) {
        this._apnsProduction = apnsProduction;
        this._timeToLive = timeToLive;
        this._globalSettingEnabled = true;
    }

    public void setBaseUrl(String baseUrl) {
        this._baseUrl = baseUrl;
    }

    public PushResult sendPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != pushPayload ? 1 : 0) != 0, (Object)"pushPayload should not be null");
        if (this._globalSettingEnabled) {
            pushPayload.resetOptionsTimeToLive(this._timeToLive);
            pushPayload.resetOptionsApnsProduction(this._apnsProduction);
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl, pushPayload.toString());
        return PushResult.fromResponse(response);
    }

    public PushResult sendPush(String payloadString) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty(payloadString), (Object)"pushPayload should not be empty");
        try {
            this._jsonParser.parse(payloadString);
        }
        catch (JsonParseException e) {
            Preconditions.checkArgument((boolean)false, (Object)"payloadString should be a valid JSON string.");
        }
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl, payloadString);
        return PushResult.fromResponse(response);
    }
}

