/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.mail;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.mail.GlobalMailAccount;
import cn.hutool.extra.mail.InternalMailUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailException;
import cn.hutool.extra.mail.UserPassAuthenticator;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Mail {
    private MailAccount mailAccount;
    private String[] tos;
    private String[] ccs;
    private String[] bccs;
    private String title;
    private String content;
    private boolean isHtml;
    private File[] files;
    private boolean useGlobalSession = true;

    public static Mail create(MailAccount mailAccount) {
        return new Mail(mailAccount);
    }

    public static Mail create() {
        return new Mail();
    }

    public Mail() {
        this(GlobalMailAccount.INSTANCE.getAccount());
    }

    public Mail(MailAccount mailAccount) {
        mailAccount = null != mailAccount ? mailAccount : GlobalMailAccount.INSTANCE.getAccount();
        this.mailAccount = mailAccount.defaultIfEmpty();
    }

    public Mail to(String ... tos) {
        return this.setTos(tos);
    }

    public Mail setTos(String ... tos) {
        this.tos = tos;
        return this;
    }

    public Mail setCcs(String ... ccs) {
        this.ccs = ccs;
        return this;
    }

    public Mail setBccs(String ... bccs) {
        this.bccs = bccs;
        return this;
    }

    public Mail setTitle(String title) {
        this.title = title;
        return this;
    }

    public Mail setContent(String content) {
        this.content = content;
        return this;
    }

    public Mail setHtml(boolean isHtml) {
        this.isHtml = isHtml;
        return this;
    }

    public Mail setFiles(File ... files) {
        this.files = files;
        return this;
    }

    public Mail setCharset(Charset charset) {
        this.mailAccount.setCharset(charset);
        return this;
    }

    public Mail setUseGlobalSession(boolean isUseGlobalSession) {
        this.useGlobalSession = isUseGlobalSession;
        return this;
    }

    public Mail send() throws MailException {
        try {
            return this.doSend();
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private Mail doSend() throws MessagingException {
        Transport.send((Message)this.buildMsg());
        return this;
    }

    private MimeMessage buildMsg() throws MessagingException {
        Charset charset = this.mailAccount.getCharset();
        MimeMessage msg = new MimeMessage(this.getSession(this.useGlobalSession));
        String from = this.mailAccount.getFrom();
        if (StrUtil.isEmpty(from)) {
            msg.setFrom();
        } else {
            msg.setFrom((Address)InternalMailUtil.parseFirstAddress(from, charset));
        }
        msg.setSubject(this.title, charset.name());
        msg.setSentDate(new Date());
        msg.setContent(this.buildContent(charset));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternalMailUtil.parseAddressFromStrs(this.tos, charset));
        if (ArrayUtil.isNotEmpty(this.ccs)) {
            msg.setRecipients(MimeMessage.RecipientType.CC, (Address[])InternalMailUtil.parseAddressFromStrs(this.ccs, charset));
        }
        if (ArrayUtil.isNotEmpty(this.bccs)) {
            msg.setRecipients(MimeMessage.RecipientType.BCC, (Address[])InternalMailUtil.parseAddressFromStrs(this.bccs, charset));
        }
        return msg;
    }

    private Multipart buildContent(Charset charset) throws MessagingException {
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)this.content, StrUtil.format((CharSequence)"text/{}; charset={}", this.isHtml ? "html" : "plain", charset));
        mainPart.addBodyPart((BodyPart)body);
        if (ArrayUtil.isNotEmpty(this.files)) {
            for (File file : this.files) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                bodyPart.setFileName(InternalMailUtil.encodeText(file.getName(), charset));
                mainPart.addBodyPart((BodyPart)bodyPart);
            }
        }
        return mainPart;
    }

    private Session getSession(boolean isSingleton) {
        UserPassAuthenticator authenticator = null;
        if (this.mailAccount.isAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(this.mailAccount.getUser(), this.mailAccount.getPass());
        }
        return isSingleton ? Session.getDefaultInstance((Properties)this.mailAccount.getSmtpProps(), authenticator) : Session.getInstance((Properties)this.mailAccount.getSmtpProps(), authenticator);
    }
}

