/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.websocket;

import cn.dreampie.websocket.Message;
import cn.dreampie.websocket.MessageClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketClient {
    private static final Logger logger = LoggerFactory.getLogger(WebsocketClient.class);
    private Session session;
    private String clientid;

    public WebsocketClient(String url, String clentid) {
        this.connect(url, clentid);
    }

    private void connect(String url, String clentid) {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        url = !url.endsWith("/") ? url + "/" + clentid : url + clentid;
        logger.info("Connecting to " + url);
        try {
            this.clientid = clentid;
            this.session = container.connectToServer(MessageClient.class, URI.create(url));
        }
        catch (DeploymentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void send(String receiverid, String message) {
        if (receiverid == null || receiverid.isEmpty()) {
            logger.info("Send: {}", (Object)"not receiver");
            return;
        }
        try {
            this.session.getBasicRemote().sendObject((Object)new Message(this.clientid, receiverid, message));
            logger.info("Send: {}", (Object)message);
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        catch (EncodeException e) {
            logger.error(e.toString());
        }
    }

    public void sendAll(String message) {
        try {
            this.session.getBasicRemote().sendObject((Object)new Message(this.clientid, "all", message));
            logger.info("Send: {}", (Object)message);
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        catch (EncodeException e) {
            logger.error(e.toString());
        }
    }

    public static void main(String[] args) {
        WebsocketClient client = new WebsocketClient("ws://localhost:9090/im", "1");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        String[] inputs = null;
        try {
            do {
                if ((input = br.readLine()).equals("exit") || !input.contains(":")) continue;
                inputs = input.split(":");
                client.send(inputs[0], inputs[1]);
            } while (!input.equals("exit"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

