/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.websocket;

import cn.dreampie.websocket.Message;
import cn.dreampie.websocket.MessageDecoder;
import cn.dreampie.websocket.MessageEncoder;
import java.io.IOException;
import java.util.Date;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(encoders={MessageEncoder.class}, decoders={MessageDecoder.class})
public class MessageClient {
    private static final Logger logger = LoggerFactory.getLogger(MessageClient.class);

    @OnOpen
    public void open(Session session) {
        try {
            session.getBasicRemote().sendObject((Object)new Message("Welcome"));
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        catch (EncodeException e) {
            logger.error(e.toString());
        }
        logger.info("Connection opened.login time {}", (Object)new Date());
    }

    @OnMessage
    public void message(Session session, Message msg) {
        if (msg != null) {
            logger.info("read message {}", (Object)msg);
        }
    }

    @OnError
    public void error(Session session, Throwable t) {
        logger.error("Connection error.get error {},get error time {}", (Object)t.toString(), (Object)new Date());
    }

    @OnClose
    public void close(Session session, CloseReason reason) {
        logger.info("Connection closed.close reson {},close time {}", (Object)reason.toString(), (Object)new Date());
    }
}

