/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.web.handler.xss;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletRequestWrapper
extends javax.servlet.http.HttpServletRequestWrapper {
    public HttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        return this.escapeAll(super.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (null == values) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.escapeAll(values[i]);
        }
        return values;
    }

    public Map<String, String[]> getParameterMap() {
        Map paramsMap = super.getParameterMap();
        if (null == paramsMap || paramsMap.isEmpty()) {
            return paramsMap;
        }
        HashMap<String, String[]> newParamsMap = new HashMap<String, String[]>(paramsMap);
        for (Map.Entry entry : paramsMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (null == values) continue;
            String[] newValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = this.escapeAll(values[i]);
            }
            newParamsMap.put(key, values);
        }
        return Collections.unmodifiableMap(newParamsMap);
    }

    public String escapeAll(String text) {
        String value = text;
        if (text == null) {
            return text;
        }
        value = this.escapeString(value);
        return value;
    }

    public String escapeString(String text) {
        String value = text;
        if (text == null) {
            return text;
        }
        value = this.escapeHtml(value);
        value = this.escapeScript(value);
        return value;
    }

    public String escapeHtml(String text) {
        String value = text;
        if (text == null) {
            return text;
        }
        value = StringEscapeUtils.escapeHtml3((String)value);
        value = StringEscapeUtils.escapeHtml4((String)value);
        return value;
    }

    public String escapeScript(String text) {
        String value = text;
        if (text == null) {
            return text;
        }
        value = StringEscapeUtils.escapeEcmaScript((String)value);
        return value;
    }
}

