/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.web.filter.gzip;

import cn.dreampie.web.filter.HttpFilter;
import cn.dreampie.web.filter.gzip.GZIPResponseWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPFilter
extends HttpFilter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String ae = request.getHeader("accept-encoding");
        if (ae != null && ae.indexOf("gzip") != -1) {
            this.logger.debug("GZIP supported, compressing.");
            GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
            wrappedResponse.finishResponse();
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

