/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.web.filter;

import cn.dreampie.web.ReturnKit;
import com.jfinal.log.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ThreadLocalKit {
    protected static final Logger logger = Logger.getLogger(ThreadLocalKit.class);
    private static ThreadLocal<HttpServletRequest> requestLocal = new ThreadLocal();
    private static ThreadLocal<ReturnKit.ReturnType> returnTypeLocal = new ThreadLocal();
    public static boolean autoJson = true;
    private static String dataTypeName = "returnType";

    public static String getDataTypeName() {
        return dataTypeName;
    }

    public static void setDataTypeName(String dataType\uff2eame) {
        dataTypeName = dataType\uff2eame;
    }

    public static void init(HttpServletRequest request) {
        ThreadLocalKit.setRequest(request);
        ThreadLocalKit.setReturnType(request);
    }

    public static void init(HttpServletRequest request, boolean autoJson) {
        ThreadLocalKit.setRequest(request);
        ThreadLocalKit.setReturnType(request);
        ThreadLocalKit.autoJson = autoJson;
    }

    public static HttpServletRequest getRequest() {
        return requestLocal.get();
    }

    public static void setRequest(HttpServletRequest request) {
        requestLocal.set(request);
    }

    public static HttpSession getSession() {
        if (requestLocal.get() != null) {
            return requestLocal.get().getSession();
        }
        return null;
    }

    public static ServletContext getServletContext() {
        if (requestLocal.get() != null) {
            return requestLocal.get().getServletContext();
        }
        return null;
    }

    public static void setReturnType(HttpServletRequest request) {
        if (ReturnKit.isJson(request)) {
            logger.debug("uri:" + request.getRequestURI() + ",return:json");
            returnTypeLocal.set(ReturnKit.ReturnType.JSON);
        } else {
            logger.debug("uri:" + request.getRequestURI() + ",return:default");
            returnTypeLocal.set(ReturnKit.ReturnType.DFAULT);
        }
    }

    public static ReturnKit.ReturnType getReturnType() {
        return returnTypeLocal.get();
    }

    public static boolean isJson() {
        return ThreadLocalKit.getReturnType() == ReturnKit.ReturnType.JSON;
    }

    public static void remove() {
        requestLocal.remove();
        returnTypeLocal.remove();
        logger.debug("remove  threadlocal");
    }
}

