/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.mail;

import cn.dreampie.PropertiesKit;
import cn.dreampie.mail.MailerConf;
import com.jfinal.plugin.IPlugin;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerPlugin
implements IPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String config = "application.properties";
    private Properties properties;
    private String host;
    private String sslport;
    private String timeout;
    private String connectout;
    private String port;
    private String ssl;
    private String tls;
    private String debug;
    private String user;
    private String password;
    private String name;
    private String from;
    private String encode;
    public static MailerConf mailerConf;

    public MailerPlugin() {
    }

    public MailerPlugin(String config) {
        this.config = config;
    }

    public boolean start() {
        this.properties = PropertiesKit.me().loadPropertyFile(this.config);
        this.host = this.properties.getProperty("smtp.host", "");
        if (this.host == null || this.host.isEmpty()) {
            throw new RuntimeException("email host has not found!");
        }
        this.port = this.properties.getProperty("smtp.port", "");
        this.ssl = this.properties.getProperty("smtp.ssl", "false");
        this.sslport = this.properties.getProperty("smtp.sslport", "");
        this.timeout = this.properties.getProperty("smtp.timeout", "60000");
        this.connectout = this.properties.getProperty("smtp.connectout", "60000");
        this.tls = this.properties.getProperty("smtp.tls", "false");
        this.debug = this.properties.getProperty("smtp.debug", "false");
        this.user = this.properties.getProperty("smtp.user", "");
        if (this.user == null || this.user.isEmpty()) {
            throw new RuntimeException("email user has not found!");
        }
        this.password = this.properties.getProperty("smtp.password", "");
        if (this.password == null || this.password.isEmpty()) {
            throw new RuntimeException("email password has not found!");
        }
        this.name = this.properties.getProperty("smtp.name", "");
        this.from = this.properties.getProperty("smtp.from", "");
        if (this.from == null || this.from.isEmpty()) {
            throw new RuntimeException("email from has not found!");
        }
        this.encode = this.properties.getProperty("smtp.encode", "UTF-8");
        mailerConf = new MailerConf(this.host, this.sslport, Integer.parseInt(this.timeout), Integer.parseInt(this.connectout), this.port, Boolean.parseBoolean(this.ssl), Boolean.parseBoolean(this.tls), Boolean.parseBoolean(this.debug), this.user, this.password, this.name, this.from, this.encode);
        return true;
    }

    public boolean stop() {
        this.host = null;
        this.port = null;
        this.ssl = null;
        this.user = null;
        this.password = null;
        this.name = null;
        this.from = null;
        return true;
    }
}

