/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.mail;

import cn.dreampie.mail.MailerConf;
import cn.dreampie.mail.MailerPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mailer {
    private static Logger logger = LoggerFactory.getLogger(Mailer.class);

    public static void sendText(String subject, String body, String ... recipients) {
        try {
            SimpleEmail simpleEmail = Mailer.getSimpleEmail(subject, body, recipients);
            simpleEmail.send();
            logger.info("send email to {}", (Object)StringUtils.join((Object[])recipients));
        }
        catch (EmailException e) {
            throw new RuntimeException("Unabled to send email", e);
        }
    }

    public static SimpleEmail getSimpleEmail(String subject, String ... recipients) throws EmailException {
        return Mailer.getSimpleEmail(subject, null, recipients);
    }

    public static SimpleEmail getSimpleEmail(String subject, String body, String ... recipients) throws EmailException {
        SimpleEmail simpleEmail = new SimpleEmail();
        Mailer.configEmail(subject, (Email)simpleEmail, recipients);
        if (body != null) {
            simpleEmail.setMsg(body);
        }
        return simpleEmail;
    }

    public static void sendHtml(String subject, String body, String ... recipients) {
        Mailer.sendHtml(subject, body, null, recipients);
    }

    public static void sendHtml(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            HtmlEmail htmlEmail = Mailer.getHtmlEmail(subject, body, attachment, recipients);
            htmlEmail.send();
            logger.info("send email to {}", (Object)StringUtils.join((Object[])recipients));
        }
        catch (EmailException e) {
            throw new RuntimeException("Unabled to send email", e);
        }
    }

    public static HtmlEmail getHtmlEmail(String subject, String ... recipients) {
        return Mailer.getHtmlEmail(subject, null, null, recipients);
    }

    public static HtmlEmail getHtmlEmail(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            HtmlEmail htmlEmail = new HtmlEmail();
            Mailer.configEmail(subject, (Email)htmlEmail, recipients);
            if (body != null) {
                htmlEmail.setHtmlMsg(body);
            }
            htmlEmail.setTextMsg("Your email client does not support HTML messages");
            if (attachment != null) {
                htmlEmail.attach(attachment);
            }
            return htmlEmail;
        }
        catch (EmailException e) {
            throw new RuntimeException("Unabled to send email", e);
        }
    }

    public static void sendAttachment(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            MultiPartEmail multiPartEmail = Mailer.getMultiPartEmail(subject, body, attachment, recipients);
            multiPartEmail.send();
            logger.info("send email to {}", (Object)StringUtils.join((Object[])recipients));
        }
        catch (EmailException e) {
            throw new RuntimeException("Unabled to send email", e);
        }
    }

    public static MultiPartEmail getMultiPartEmail(String subject, String ... recipients) {
        return Mailer.getMultiPartEmail(subject, null, null, recipients);
    }

    public static MultiPartEmail getMultiPartEmail(String subject, String body, EmailAttachment attachment, String ... recipients) {
        try {
            MultiPartEmail multiPartEmail = new MultiPartEmail();
            Mailer.configEmail(subject, (Email)multiPartEmail, recipients);
            if (body != null) {
                multiPartEmail.setMsg(body);
            }
            if (attachment != null) {
                multiPartEmail.attach(attachment);
            }
            return multiPartEmail;
        }
        catch (EmailException e) {
            throw new RuntimeException("Unabled to send email", e);
        }
    }

    private static void configEmail(String subject, Email email, String ... recipients) throws EmailException {
        if (recipients == null) {
            throw new EmailException("Recipients not found.");
        }
        MailerConf mailerConf = MailerPlugin.mailerConf;
        email.setCharset(mailerConf.getCharset());
        email.setSocketTimeout(mailerConf.getTimeout());
        email.setSocketConnectionTimeout(mailerConf.getConnectout());
        email.setCharset(mailerConf.getEncode());
        email.setHostName(mailerConf.getHost());
        if (!mailerConf.getSslport().isEmpty()) {
            email.setSslSmtpPort(mailerConf.getSslport());
        }
        if (!mailerConf.getPort().isEmpty()) {
            email.setSmtpPort(Integer.parseInt(mailerConf.getPort()));
        }
        email.setSSLOnConnect(mailerConf.isSsl());
        email.setStartTLSEnabled(mailerConf.isTls());
        email.setDebug(mailerConf.isDebug());
        email.setAuthentication(mailerConf.getUser(), mailerConf.getPassword());
        email.setFrom(mailerConf.getFrom(), mailerConf.getName());
        email.setSubject(subject);
        email.addTo(recipients);
    }
}

