/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.mail;

import cn.dreampie.mail.Mailer;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorMailer {
    private static Logger logger = LoggerFactory.getLogger(Mailer.class);
    private static ExecutorService executorService = null;

    public static ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool();
        }
        return executorService;
    }

    public static void setExecutorService(ExecutorService executorService) {
        ExecutorMailer.executorService = executorService;
    }

    public static void sendText(String subject, String body, String ... recipients) {
        ExecutorMailer.getExecutorService().execute(ExecutorMailer.getSendTextRunnable(subject, body, recipients));
    }

    private static Runnable getSendTextRunnable(final String subject, final String body, final String ... recipients) {
        return new Runnable(){

            public void run() {
                Mailer.sendText(subject, body, recipients);
            }
        };
    }

    public static void sendHtml(String subject, String body, String ... recipients) throws EmailException {
        ExecutorMailer.sendHtml(subject, body, null, recipients);
    }

    public static void sendHtml(String subject, String body, EmailAttachment attachment, String ... recipients) {
        ExecutorMailer.getExecutorService().execute(ExecutorMailer.getSendHtmlRunable(subject, body, attachment, recipients));
    }

    private static Runnable getSendHtmlRunable(final String subject, final String body, final EmailAttachment attachment, final String ... recipients) {
        return new Runnable(){

            public void run() {
                Mailer.sendHtml(subject, body, attachment, recipients);
            }
        };
    }

    public static void sendAttachment(String subject, String body, EmailAttachment attachment, String ... recipients) {
        ExecutorMailer.getExecutorService().execute(ExecutorMailer.getSendAttachRunnable(subject, body, attachment, recipients));
    }

    private static Runnable getSendAttachRunnable(final String subject, final String body, final EmailAttachment attachment, final String ... recipients) {
        return new Runnable(){

            public void run() {
                Mailer.sendAttachment(subject, body, attachment, recipients);
            }
        };
    }

    public void shutdown() {
        ExecutorMailer.getExecutorService().shutdown();
    }

    public List<Runnable> shutdownNow() {
        return ExecutorMailer.getExecutorService().shutdownNow();
    }
}

