/*
 * Decompiled with CFR 0.152.
 */
package cn.dreampie.mail;

import akka.actor.Scheduler;
import cn.dreampie.akka.Akka;
import cn.dreampie.mail.Mailer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public class AkkaMailer {
    private static Scheduler scheduler = null;

    public static Scheduler getScheduler() {
        if (scheduler == null) {
            scheduler = Akka.system().scheduler();
        }
        return scheduler;
    }

    public static void setScheduler(Scheduler scheduler) {
        AkkaMailer.scheduler = scheduler;
    }

    public static void sendText(String subject, String body, String ... recipients) {
        AkkaMailer.getScheduler().scheduleOnce(Duration.create((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), AkkaMailer.getSendTextRunnable(subject, body, recipients), (ExecutionContext)Akka.system().dispatcher());
    }

    private static Runnable getSendTextRunnable(final String subject, final String body, final String ... recipients) {
        return new Runnable(){

            public void run() {
                Mailer.sendText(subject, body, recipients);
            }
        };
    }

    public static void sendHtml(String subject, String body, String ... recipients) throws EmailException {
        AkkaMailer.sendHtml(subject, body, null, recipients);
    }

    public static void sendHtml(String subject, String body, EmailAttachment attachment, String ... recipients) {
        AkkaMailer.getScheduler().scheduleOnce(Duration.create((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), AkkaMailer.getSendHtmlRunable(subject, body, attachment, recipients), (ExecutionContext)Akka.system().dispatcher());
    }

    private static Runnable getSendHtmlRunable(final String subject, final String body, final EmailAttachment attachment, final String ... recipients) {
        return new Runnable(){

            public void run() {
                Mailer.sendHtml(subject, body, attachment, recipients);
            }
        };
    }

    public static void sendAttachment(String subject, String body, EmailAttachment attachment, String ... recipients) {
        AkkaMailer.getScheduler().scheduleOnce(Duration.create((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), AkkaMailer.getSendAttachmentRunnable(subject, body, attachment, recipients), (ExecutionContext)Akka.system().dispatcher());
    }

    private static Runnable getSendAttachmentRunnable(final String subject, final String body, final EmailAttachment attachment, final String ... recipients) {
        return new Runnable(){

            public void run() {
                Mailer.sendAttachment(subject, body, attachment, recipients);
            }
        };
    }
}

