/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.sigar;

import club.zhcs.sigar.SigarFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;

public class SigarMetrics
implements PublicMetrics {
    Log logger = Logs.get();

    public Collection<Metric<?>> metrics() {
        ArrayList metrics = new ArrayList();
        try {
            Sigar sigar = SigarFactory.load();
            metrics.add(new Metric("cpu.total", (Number)sigar.getCpu().getTotal()));
            metrics.add(new Metric("cpu.idle", (Number)sigar.getCpu().getIdle()));
            metrics.add(new Metric("cpu.irq", (Number)sigar.getCpu().getIrq()));
            metrics.add(new Metric("cpu.nice", (Number)sigar.getCpu().getNice()));
            metrics.add(new Metric("cpu.soft.irq", (Number)sigar.getCpu().getSoftIrq()));
            metrics.add(new Metric("cpu.stolen", (Number)sigar.getCpu().getStolen()));
            metrics.add(new Metric("cpu.sys", (Number)sigar.getCpu().getSys()));
            metrics.add(new Metric("cpu.user", (Number)sigar.getCpu().getUser()));
            metrics.add(new Metric("cpu.wait", (Number)sigar.getCpu().getWait()));
            metrics.add(new Metric("cpu.usage", (Number)(sigar.getCpuPerc().getCombined() * 100.0)));
            metrics.add(new Metric("mem.free", (Number)sigar.getMem().getFree()));
            metrics.add(new Metric("mem.actual.free", (Number)sigar.getMem().getActualFree()));
            metrics.add(new Metric("mem.actual.used", (Number)sigar.getMem().getActualUsed()));
            metrics.add(new Metric("mem.free.percent", (Number)sigar.getMem().getFreePercent()));
            metrics.add(new Metric("mem.ram", (Number)sigar.getMem().getRam()));
            metrics.add(new Metric("mem.total", (Number)sigar.getMem().getTotal()));
            metrics.add(new Metric("mem.used", (Number)sigar.getMem().getUsed()));
            metrics.add(new Metric("mem.user.percent", (Number)sigar.getMem().getUsedPercent()));
            metrics.add(new Metric("tcp.active.opens", (Number)sigar.getTcp().getActiveOpens()));
            metrics.add(new Metric("tcp.attempt.fails", (Number)sigar.getTcp().getAttemptFails()));
            metrics.add(new Metric("tcp.curre.stab", (Number)sigar.getTcp().getCurrEstab()));
            metrics.add(new Metric("tcp.estab.resets", (Number)sigar.getTcp().getEstabResets()));
            metrics.add(new Metric("tcp.in.errs", (Number)sigar.getTcp().getInErrs()));
            metrics.add(new Metric("tcp.in.segs", (Number)sigar.getTcp().getInSegs()));
            metrics.add(new Metric("tcp.out.rsts", (Number)sigar.getTcp().getOutRsts()));
            metrics.add(new Metric("tcp.out.segs", (Number)sigar.getTcp().getOutSegs()));
            metrics.add(new Metric("tcp.passive.opens", (Number)sigar.getTcp().getPassiveOpens()));
            metrics.add(new Metric("tcp.retrans.segs", (Number)sigar.getTcp().getRetransSegs()));
            metrics.add(new Metric("swap.free", (Number)sigar.getSwap().getFree()));
            metrics.add(new Metric("swap.page.in", (Number)sigar.getSwap().getPageIn()));
            metrics.add(new Metric("swap.page.out", (Number)sigar.getSwap().getPageOut()));
            metrics.add(new Metric("swap.total", (Number)sigar.getSwap().getTotal()));
            metrics.add(new Metric("swap.used", (Number)sigar.getSwap().getUsed()));
            metrics.add(new Metric("swap.usage", (Number)(sigar.getSwap().getUsed() * 100L / sigar.getSwap().getTotal())));
            Runtime runtime = Runtime.getRuntime();
            long max = runtime.maxMemory();
            long total = runtime.totalMemory();
            long free = runtime.freeMemory();
            long usable = max - total + free;
            double freePercent = 100L * usable / max;
            double usedPercent = 100.0 - freePercent;
            metrics.add(new Metric("jvm.max", (Number)max));
            metrics.add(new Metric("jvm.free", (Number)free));
            metrics.add(new Metric("jvm.total", (Number)total));
            metrics.add(new Metric("jvm.usable", (Number)usable));
            metrics.add(new Metric("jvm.free.percent", (Number)freePercent));
            metrics.add(new Metric("jvm.usage", (Number)usedPercent));
            long read = 0L;
            long write = 0L;
            for (FileSystem fs : sigar.getFileSystemList()) {
                if (fs.getType() != 2) continue;
                try {
                    FileSystemUsage usage = sigar.getFileSystemUsage(fs.getDirName());
                    read += usage.getDiskReadBytes();
                    write += usage.getDiskWriteBytes();
                }
                catch (SigarException e) {
                    e.printStackTrace();
                }
            }
            metrics.add(new Metric("disk.read", (Number)read));
            metrics.add(new Metric("disk.write", (Number)write));
        }
        catch (SigarException e) {
            e.printStackTrace();
        }
        return metrics;
    }
}

