/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.utils;

import club.zhcs.utils.Downloader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nutz.filepool.NutFilePool;
import org.nutz.http.Header;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.http.sender.PostSender;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.repo.Base64;

public class Images
extends org.nutz.img.Images {
    static NutFilePool pool = new NutFilePool(System.getProperty("java.io.tmpdir"), 3000L);
    private static final Log log = Logs.get();

    public static BufferedImage zoomAndClip(File src, double scale, int startX, int startY, int endX, int endY) throws IOException {
        BufferedImage bfi = Images.read((Object)src);
        bfi = Images.zoomScale((BufferedImage)bfi, (int)((int)((double)bfi.getWidth() * scale)), (int)((int)((double)bfi.getHeight() * scale)));
        File f = pool.createFile("." + Files.getSuffixName((File)src));
        Images.write((RenderedImage)bfi, (File)f);
        bfi = Images.clipScale((String)f.getPath(), (String)f.getPath(), (int[])new int[]{startX, startY}, (int[])new int[]{endX, endY});
        return Images.read((Object)f);
    }

    public static BufferedImage zoomAndClip(File src, double scale, Point start, Point end) throws IOException {
        return Images.zoomAndClip(src, scale, start.getX(), start.getY(), end.getX(), end.getY());
    }

    public static File toFile(BufferedImage bfi) {
        File f = pool.createFile(".jpg");
        Images.writeJpeg((RenderedImage)bfi, (Object)f, (float)1.0f);
        return f;
    }

    public static BufferedImage zoomAndClip(File src, double scale, Point start, int w, int h) throws IOException {
        return Images.zoomAndClip(src, scale, start.getX(), start.getY(), start.getX() + w, start.getY() + h);
    }

    public static BufferedImage zoomAndClip(String srcPath, double scale, Point start, int w, int h) throws Exception {
        Downloader downloader = new Downloader();
        File f = null;
        f = pool.createFile(".png");
        downloader.setUrlAndFile(new URL(srcPath), f);
        f = downloader.call();
        return Images.zoomAndClip(f, scale, start, w, h);
    }

    public static File GenerateImage(String imgStr, File outFile) {
        if (imgStr == null) {
            return null;
        }
        try {
            byte[] b = Base64.decode((String)imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            FileOutputStream out = new FileOutputStream(outFile);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return outFile;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    public static File GenerateImage(String imgStr, File outDir, String suffix) {
        File file = new File(outDir.getPath() + File.separator + System.nanoTime() + "." + suffix);
        return Images.GenerateImage(imgStr, file);
    }

    public static File GeneratePngImage(String imgStr) {
        return Images.GenerateImage(imgStr, new File(System.nanoTime() + ".png"));
    }

    public static String GetImageStr(File imgFile) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        return Base64.encodeToString((byte[])data, (boolean)false);
    }

    public static NutMap baiduOcr(String path, String key) {
        NutMap params = NutMap.NEW();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("apikey", key);
        params.put((Object)"fromdevice", (Object)"pc");
        params.put((Object)"clientip", (Object)"10.0.1.1");
        params.put((Object)"detecttype", (Object)"LocateRecognize");
        params.put((Object)"languagetype", (Object)"CHN_ENG");
        params.put((Object)"imagetype", (Object)"1");
        params.put((Object)"image", (Object)Images.GetImageStr(new File(path)));
        Request request = Request.create((String)"http://apis.baidu.com/apistore/idlocr/ocr", (Request.METHOD)Request.METHOD.POST, (Map)params, (Header)Header.create(header));
        Sender sender = PostSender.create((Request)request);
        Response response = sender.send();
        String info = response.getContent();
        return Lang.map((String)info);
    }

    public static class Point {
        private int x;
        private int y;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Point(Number x, Number y) {
            this.x = x.intValue();
            this.y = y.intValue();
        }

        public Point() {
        }
    }
}

