/*
 * Decompiled with CFR 0.152.
 */
package club.zhcs.apm;

import club.zhcs.apm.APM;
import club.zhcs.apm.APMAppender;
import club.zhcs.apm.URLProvider;
import club.zhcs.apm.UserCollector;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.nutz.lang.Stopwatch;
import org.nutz.lang.Times;
import org.springframework.scheduling.annotation.Async;

@Aspect
public class APMInterceptor {
    APMAppender appender;
    UserCollector collector;
    URLProvider urlProvider;

    public APMInterceptor(APMAppender appender, UserCollector collector, URLProvider urlProvider) {
        this.appender = appender;
        this.collector = collector;
        this.urlProvider = urlProvider;
    }

    @Pointcut(value="@annotation(club.zhcs.apm.APM)")
    public void cut() {
    }

    public APM getApm(JoinPoint joinPoint) throws Exception {
        String targetName = joinPoint.getTarget().getClass().getName();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        APM target = null;
        for (Method method : methods) {
            Class<?>[] clazzs;
            if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
            target = method.getAnnotation(APM.class);
            break;
        }
        return target;
    }

    @Around(value="cut()")
    public Object filter(ProceedingJoinPoint point) throws Throwable {
        APM log = this.getApm((JoinPoint)point);
        String user = this.collector.collector();
        APMAppender.APMLog apmLog = new APMAppender.APMLog();
        apmLog.setUser(user);
        apmLog.setTag(log.value());
        apmLog.setActionTime(Times.now());
        apmLog.setArgs(point.getArgs());
        if (this.urlProvider != null) {
            apmLog.setUrl(this.urlProvider.provide());
        }
        Object obj = null;
        try {
            Stopwatch stopwatch = Stopwatch.beginNano();
            obj = point.proceed();
            stopwatch.stop();
            apmLog.setActionDuration(stopwatch.getDuration());
            apmLog.setRetuenObj(obj);
        }
        catch (Throwable e) {
            apmLog.setException(true);
            throw e;
        }
        finally {
            this.log(apmLog);
        }
        return obj;
    }

    @Async
    public void log(APMAppender.APMLog log) {
        this.appender.append(log);
    }
}

