/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.activation.appliance.Home;
import org.apache.avalon.composition.util.ExceptionHelper;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

class DefaultServiceManager
extends AbstractLogEnabled
implements ServiceManager {
    private final Map m_map;
    private final Hashtable m_table = new Hashtable();

    public DefaultServiceManager(Logger logger, Map map) {
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (map == null) {
            throw new NullPointerException("map");
        }
        super.enableLogging(logger);
        this.m_map = map;
    }

    public boolean hasService(String key) {
        return this.m_map.get(key) != null;
    }

    public Object lookup(String key) throws ServiceException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.hasService(key)) {
            String error = "Unknown key: " + key;
            throw new ServiceException(key, error);
        }
        Home provider = (Home)this.m_map.get(key);
        try {
            Object object = provider.resolve((Object)this);
            String id = "" + System.identityHashCode(object);
            this.m_table.put(id, key);
            String message = "resolved service [" + id + "] for the key [" + key + "].";
            this.getLogger().debug(message);
            return object;
        }
        catch (Throwable e) {
            String error = "Unexpected runtime error while attempting to resolve service for key: " + key;
            throw new ServiceException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object object) {
        if (object == null) {
            return;
        }
        String id = "" + System.identityHashCode(object);
        String key = (String)this.m_table.get(id);
        if (key == null) {
            String warning = "Unrecognized object identity [" + id + "]. " + "Either this object was not provided by this service manager " + "or it has already been released.";
            this.getLogger().warn(warning);
            return;
        }
        Home provider = (Home)this.m_map.get(key);
        if (provider == null) {
            String error = "Unable to release component as no provider could be found for the key [" + key + "].";
            throw new IllegalStateException(error);
        }
        try {
            provider.release((Object)this, object);
            String message = "released service [" + id + "] from the key [" + key + "].";
            this.getLogger().debug(message);
        }
        catch (Throwable e) {
            String error = "Internal error while attempting to release object from provider: " + provider;
            String warning = ExceptionHelper.packException((String)error, (Throwable)e, (boolean)true);
            this.getLogger().warn(warning);
        }
        finally {
            this.m_table.remove(id);
        }
    }
}

