/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceException;
import org.apache.avalon.activation.appliance.ApplianceRepository;
import org.apache.avalon.activation.appliance.AssemblyException;
import org.apache.avalon.activation.appliance.Block;
import org.apache.avalon.activation.appliance.Composite;
import org.apache.avalon.activation.appliance.DependencyGraph;
import org.apache.avalon.activation.appliance.DeploymentException;
import org.apache.avalon.activation.appliance.Engine;
import org.apache.avalon.activation.appliance.NoProviderDefinitionException;
import org.apache.avalon.activation.appliance.ServiceContext;
import org.apache.avalon.activation.appliance.impl.AbstractAppliance;
import org.apache.avalon.activation.appliance.impl.BlockThread;
import org.apache.avalon.activation.appliance.impl.DefaultAppliance;
import org.apache.avalon.activation.appliance.impl.DefaultApplianceRepository;
import org.apache.avalon.activation.appliance.impl.DefaultState;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.Model;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

public class DefaultBlock
extends AbstractAppliance
implements Block,
Composite {
    private final DefaultApplianceRepository m_repository;
    private final ServiceContext m_context;
    private final Map m_appliances = new Hashtable();
    private final DependencyGraph m_graph;
    private final Engine m_engine;
    private final ContainmentModel m_model;
    private final DefaultState m_assembly = new DefaultState();
    private final DefaultState m_deployment = new DefaultState();
    private final DefaultState m_self = new DefaultState();
    private final Hashtable m_threads = new Hashtable();
    private final Object m_proxy;
    static /* synthetic */ Class class$java$lang$Object;

    public static Block createRootBlock(ServiceContext context, ContainmentModel model) throws Exception {
        Logger logger = context.getLoggingManager().getLoggerForCategory("");
        DefaultApplianceRepository repository = new DefaultApplianceRepository();
        DependencyGraph graph = new DependencyGraph();
        return new DefaultBlock(logger, model, graph, context, null, repository);
    }

    DefaultBlock(Logger logger, ContainmentModel model, DependencyGraph graph, ServiceContext context, Engine engine, ApplianceRepository repository) throws ApplianceException {
        super(logger, (Model)model);
        if (graph == null) {
            throw new NullPointerException("graph");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (repository == null) {
            throw new NullPointerException("repository");
        }
        this.m_repository = new DefaultApplianceRepository(repository);
        this.m_model = model;
        this.m_context = context;
        this.m_engine = engine;
        this.m_graph = graph;
        this.m_self.setEnabled(true);
        Model[] models = model.getModels();
        for (int i = models.length - 1; i > -1; --i) {
            Appliance appliance = this.createAppliance(models[i]);
            this.m_repository.addAppliance(appliance);
        }
        try {
            Logger log = this.getLogger().getChildLogger("proxy");
            BlockInvocationHandler handler = new BlockInvocationHandler(log, this);
            Class[] classes = this.getInterfaceClasses();
            this.m_proxy = Proxy.newProxyInstance(this.m_model.getClassLoaderModel().getClassLoader(), classes, (InvocationHandler)handler);
        }
        catch (Throwable e) {
            String error = "Virtual service establishment failure in block: " + (Object)((Object)this);
            throw new ApplianceException(error, e);
        }
    }

    public Appliance resolveAppliance(DependencyModel dependency) throws Exception {
        String path = dependency.getPath();
        if (path != null) {
            return this.resolveAppliance(path);
        }
        return this.resolveAppliance(dependency.getDependency());
    }

    public Appliance resolveAppliance(DependencyDescriptor dependency) throws Exception {
        Appliance appliance;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolving provider for: " + dependency);
        }
        if ((appliance = this.m_repository.getAppliance(dependency)) != null) {
            return appliance;
        }
        Model model = this.m_model.getModel(dependency);
        if (model != null) {
            appliance = this.createAppliance(model);
            if (appliance instanceof Composite) {
                ((Composite)appliance).assemble();
            }
            this.m_repository.addAppliance(appliance);
            return appliance;
        }
        if (this.m_engine != null) {
            return this.m_engine.resolveAppliance(dependency);
        }
        throw new NoProviderDefinitionException("Unable to resolve dependency: " + dependency);
    }

    public Appliance resolveAppliance(StageModel stage) throws Exception {
        String path = stage.getPath();
        if (path != null) {
            return this.resolveAppliance(path);
        }
        return this.resolveAppliance(stage.getStage());
    }

    public Appliance resolveAppliance(StageDescriptor stage) throws NoProviderDefinitionException, Exception {
        Appliance appliance;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("resolving stage provider for: " + stage);
        }
        if ((appliance = this.m_repository.getAppliance(stage)) != null) {
            return appliance;
        }
        Model model = this.m_model.getModel(stage);
        if (model != null) {
            appliance = this.createAppliance(model);
            if (appliance instanceof Composite) {
                ((Composite)appliance).assemble();
            }
            this.m_repository.addAppliance(appliance);
            return appliance;
        }
        if (this.m_engine != null) {
            return this.m_engine.resolveAppliance(stage);
        }
        throw new NoProviderDefinitionException("Unable to resolve stage handler for: " + stage);
    }

    public Appliance resolveAppliance(String source) throws Exception {
        String base;
        String path = source;
        if (source.endsWith("/")) {
            path = source.substring(0, source.length() - 1);
        }
        if (path.equals(base = this.getModel().getQualifiedName())) {
            return this;
        }
        if (path.startsWith(base)) {
            String name = path.substring(base.length());
            int j = name.indexOf("/");
            if (j == -1) {
                return this.m_repository.getLocalAppliance(name);
            }
            if (j == 0) {
                return this.m_repository.getLocalAppliance(name.substring(1));
            }
            String root = name.substring(0, j);
            Appliance child = this.m_repository.getLocalAppliance(root);
            if (child instanceof Engine) {
                return ((Engine)child).resolveAppliance(path);
            }
            String error = "Not a container: " + path;
            throw new ApplianceException(error);
        }
        if (base.startsWith(path)) {
            if (this.m_engine != null) {
                return this.m_engine.resolveAppliance(path);
            }
            String error = "Invalid absolute reference: " + path;
            throw new IllegalArgumentException(error);
        }
        return this.m_repository.getLocalAppliance(path);
    }

    public boolean isAssembled() {
        return this.m_assembly.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble() throws AssemblyException {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (this.isAssembled()) {
                return;
            }
            this.getLogger().debug("assembly phase");
            Appliance[] appliances = this.m_repository.getAppliances();
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (!(appliance instanceof Composite)) continue;
                ((Composite)appliance).assemble();
            }
            this.m_assembly.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassemble() {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (!this.isAssembled()) {
                return;
            }
            this.getLogger().debug("dissassembly phase");
            Appliance[] appliances = this.m_repository.getAppliances();
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (!(appliance instanceof Composite)) continue;
                ((Composite)appliance).disassemble();
            }
            this.m_assembly.setEnabled(false);
        }
    }

    public Appliance[] getProviders() {
        if (!this.isAssembled()) {
            throw new IllegalStateException("assembly");
        }
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        Appliance[] appliances = this.m_repository.getAppliances();
        for (int i = 0; i < appliances.length; ++i) {
            Appliance appliance = appliances[i];
            if (!(appliance instanceof Composite)) continue;
            Appliance[] providers = ((Composite)appliance).getProviders();
            for (int j = 0; j < providers.length; ++j) {
                Appliance provider = providers[j];
                String path = provider.getModel().getPath();
                if (path.startsWith(this.m_model.getPartition())) continue;
                list.add(providers[j]);
            }
        }
        return list.toArray(new Appliance[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Exception {
        if (!this.isAssembled()) {
            throw new IllegalStateException("assembly");
        }
        DefaultState defaultState = this.m_deployment;
        synchronized (defaultState) {
            if (this.m_deployment.isEnabled()) {
                return;
            }
            Appliance[] appliances = this.getLocalStartupSequence();
            if (this.getLogger().isDebugEnabled()) {
                String message = this.listAppliances("deployment: ", appliances);
                this.getLogger().debug(message);
            }
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (appliance instanceof Block) {
                    Block block = (Block)appliance;
                    BlockThread thread = new BlockThread(block);
                    this.m_threads.put(block, thread);
                    thread.start();
                    while (!thread.started()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(300L);
                        }
                        catch (Throwable e) {}
                    }
                    if (thread.getError() == null) continue;
                    String error = "Composite deployment failure in block: [" + block + "]";
                    throw new DeploymentException(error, thread.getError());
                }
                appliances[i].deploy();
            }
            this.m_deployment.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommission() {
        if (!this.isAssembled()) {
            return;
        }
        DefaultState defaultState = this.m_deployment;
        synchronized (defaultState) {
            if (!this.m_deployment.isEnabled()) {
                return;
            }
            Appliance[] appliances = this.getLocalShutdownSequence();
            if (this.getLogger().isDebugEnabled()) {
                String message = this.listAppliances("decommissioning: ", appliances);
                this.getLogger().debug(message);
            }
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (appliance instanceof Block) {
                    BlockThread thread = (BlockThread)this.m_threads.get(appliance);
                    thread.decommission();
                    while (!thread.stopped()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(300L);
                        }
                        catch (Throwable e) {}
                    }
                    continue;
                }
                appliance.decommission();
            }
            this.m_deployment.setEnabled(false);
        }
    }

    public Object resolve(Object consumer) throws Exception {
        return this.resolve(consumer, new Class[0]);
    }

    public Object resolve(Object source, Class[] ref) throws Exception {
        return this.m_proxy;
    }

    public void release(Object source, Object instance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DefaultState defaultState = this.m_self;
        synchronized (defaultState) {
            if (!this.m_self.isEnabled()) {
                return;
            }
            this.getLogger().debug("disposal phase");
            Appliance[] appliances = this.m_repository.getAppliances();
            for (int i = 0; i < appliances.length; ++i) {
                Appliance appliance = appliances[i];
                if (!(appliance instanceof Disposable)) continue;
                ((Disposable)appliance).dispose();
            }
            this.m_self.setEnabled(false);
        }
    }

    private Appliance[] getLocalStartupSequence() {
        Appliance[] appliances = this.getDependencyGraph().getStartupGraph();
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        for (int i = 0; i < appliances.length; ++i) {
            Appliance appliance = appliances[i];
            String path = appliance.getModel().getPath();
            if (!path.startsWith(this.m_model.getPartition())) continue;
            list.add(appliance);
        }
        return list.toArray(new Appliance[0]);
    }

    private Appliance[] getLocalShutdownSequence() {
        Appliance[] appliances = this.getDependencyGraph().getShutdownGraph();
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        for (int i = 0; i < appliances.length; ++i) {
            Appliance appliance = appliances[i];
            String path = appliance.getModel().getPath();
            if (!path.startsWith(this.m_model.getPartition())) continue;
            list.add(appliance);
        }
        return list.toArray(new Appliance[0]);
    }

    private String listAppliances(String header, Appliance[] appliances) {
        if (appliances.length > 0) {
            boolean flag = true;
            StringBuffer buffer = new StringBuffer(header);
            for (int i = 0; i < appliances.length; ++i) {
                if (flag) {
                    buffer.append(appliances[i]);
                    flag = false;
                    continue;
                }
                buffer.append(", " + appliances[i]);
            }
            return buffer.toString();
        }
        return new String(header + " (empty)");
    }

    private DependencyGraph getDependencyGraph() {
        return this.m_graph;
    }

    public Appliance createAppliance(Model model) throws ApplianceException {
        String path = model.getPath() + model.getName();
        AbstractAppliance appliance = null;
        if (model instanceof DeploymentModel) {
            this.getLogger().debug("creating appliance: " + path);
            DeploymentModel deployment = (DeploymentModel)model;
            CategoriesDirective categories = deployment.getCategories();
            if (categories != null) {
                this.m_context.getLoggingManager().addCategories(path, categories);
            }
            Logger logger = this.m_context.getLoggingManager().getLoggerForCategory(path);
            appliance = new DefaultAppliance(logger, this.m_context, deployment, (Engine)this);
        } else if (model instanceof ContainmentModel) {
            this.getLogger().debug("creating block: " + path);
            ContainmentModel containment = (ContainmentModel)model;
            CategoriesDirective categories = containment.getCategories();
            if (categories != null) {
                this.m_context.getLoggingManager().addCategories(path, categories);
            }
            Logger logger = this.m_context.getLoggingManager().getLoggerForCategory(path);
            DefaultApplianceRepository repository = new DefaultApplianceRepository(this.m_repository);
            appliance = new DefaultBlock(logger, containment, new DependencyGraph(this.m_graph), this.m_context, (Engine)this, repository);
        } else {
            String error = "Unrecognized model: " + model.getClass().getName();
            throw new IllegalArgumentException(error);
        }
        this.m_graph.add((Appliance)appliance);
        return appliance;
    }

    public String toString() {
        return "block:" + this.getModel().getQualifiedName();
    }

    private Class[] getInterfaceClasses() throws Exception {
        ClassLoader loader = this.m_model.getClassLoaderModel().getClassLoader();
        ArrayList list = new ArrayList();
        ServiceDirective[] services = this.m_model.getExportDirectives();
        for (int i = 0; i < services.length; ++i) {
            ServiceDirective service = services[i];
            String classname = service.getReference().getClassname();
            try {
                Class<?> clazz = loader.loadClass(classname);
                list.add(clazz);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                String error = "Class not found: [" + classname + "] in block [" + (Object)((Object)this) + "] with classloader content: \n";
                StringBuffer buffer = new StringBuffer(error);
                if (loader instanceof URLClassLoader) {
                    URL[] urls = ((URLClassLoader)loader).getURLs();
                    for (int j = 0; j < urls.length; ++j) {
                        buffer.append("\n  " + urls[j].toString());
                    }
                }
                String message = buffer.toString();
                throw new ApplianceException(message);
            }
        }
        return list.toArray(new Class[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class BlockInvocationHandler
    implements InvocationHandler {
        private final DefaultBlock m_block;
        private final Logger m_logger;

        protected BlockInvocationHandler(Logger logger, DefaultBlock block) throws Exception {
            if (block == null) {
                throw new NullPointerException("block");
            }
            this.m_block = block;
            this.m_logger = logger;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (proxy == null) {
                throw new NullPointerException("proxy");
            }
            if (method == null) {
                throw new NullPointerException("method");
            }
            if (method.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = DefaultBlock.class$("java.lang.Object")) : class$java$lang$Object)) {
                this.m_logger.debug("invocation: " + method.getName());
                try {
                    return method.invoke((Object)this.m_block, args);
                }
                catch (InvocationTargetException e) {
                    String error = "Unexpected delegation error on java.lang.Object";
                    throw new ApplianceException("Unexpected delegation error on java.lang.Object", e.getTargetException());
                }
            }
            ServiceDirective service = DefaultBlock.this.m_model.getExportDirective(method.getDeclaringClass());
            String path = service.getPath();
            Appliance provider = this.m_block.resolveAppliance(path);
            this.m_logger.debug("delegating: " + method.getName());
            try {
                Object object = provider.resolve((Object)this);
                return method.invoke(object, args);
            }
            catch (InvocationTargetException e) {
                String error = "Delegation error raised by provider: " + provider;
                throw new ApplianceException(error, e.getTargetException());
            }
            catch (Throwable e) {
                String error = "Composite service resolution failure for the class: '" + method.getDeclaringClass() + "' for operation: '" + method.getName() + "' in appliance: " + (Object)((Object)this.m_block);
                throw new ApplianceException(error, e);
            }
        }
    }
}

