/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.AssemblyException;
import org.apache.avalon.activation.appliance.Composite;
import org.apache.avalon.activation.appliance.Engine;
import org.apache.avalon.activation.appliance.ServiceContext;
import org.apache.avalon.activation.appliance.impl.AbstractAppliance;
import org.apache.avalon.activation.appliance.impl.DefaultServiceManager;
import org.apache.avalon.activation.appliance.impl.DefaultState;
import org.apache.avalon.activation.lifecycle.ContextualizationHandler;
import org.apache.avalon.activation.lifecycle.Factory;
import org.apache.avalon.activation.lifecycle.LifecycleCreateExtension;
import org.apache.avalon.activation.lifecycle.LifecycleDestroyExtension;
import org.apache.avalon.activation.lifecycle.LifecycleException;
import org.apache.avalon.activation.lifestyle.LifestyleHandler;
import org.apache.avalon.activation.lifestyle.impl.PooledLifestyleHandler;
import org.apache.avalon.activation.lifestyle.impl.SingletonLifestyleHandler;
import org.apache.avalon.activation.lifestyle.impl.ThreadLifestyleHandler;
import org.apache.avalon.activation.lifestyle.impl.TransientLifestyleHandler;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.logging.LoggingManager;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.DependencyModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.Model;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.lifecycle.Accessor;
import org.apache.avalon.lifecycle.Creator;
import org.apache.avalon.meta.info.StageDescriptor;

public class DefaultAppliance
extends AbstractAppliance
implements Composite,
Factory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$appliance$impl$DefaultAppliance == null ? (class$org$apache$avalon$activation$appliance$impl$DefaultAppliance = DefaultAppliance.class$("org.apache.avalon.activation.appliance.impl.DefaultAppliance")) : class$org$apache$avalon$activation$appliance$impl$DefaultAppliance));
    private final Hashtable m_providers = new Hashtable();
    private final Hashtable m_stages = new Hashtable();
    private final DeploymentModel m_model;
    private final Engine m_engine;
    private final DefaultState m_assembly = new DefaultState();
    private final DefaultState m_deployment = new DefaultState();
    private final ServiceContext m_context;
    private LifestyleHandler m_lifestyle = null;
    private Appliance m_contextProvider = null;
    private ContextualizationHandler m_contextualization = null;
    private Logger m_logger;
    static /* synthetic */ Class class$org$apache$avalon$activation$appliance$impl$DefaultAppliance;
    static /* synthetic */ Class class$org$apache$avalon$activation$lifecycle$ContextualizationHandler;
    static /* synthetic */ Class class$org$apache$avalon$lifecycle$Creator;
    static /* synthetic */ Class class$org$apache$avalon$activation$lifecycle$LifecycleCreateExtension;
    static /* synthetic */ Class class$org$apache$avalon$activation$lifecycle$LifecycleDestroyExtension;
    static /* synthetic */ Class class$org$apache$avalon$lifecycle$Accessor;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;

    public DefaultAppliance(Logger logger, ServiceContext context, DeploymentModel model, Engine engine) {
        super(logger.getChildLogger("appliance"), (Model)model);
        this.m_logger = logger;
        this.m_context = context;
        this.m_model = model;
        this.m_engine = engine;
    }

    private Appliance getContextProvider() {
        return this.m_contextProvider;
    }

    private Appliance getStageProvider(StageDescriptor stage) throws IllegalArgumentException {
        String key = stage.getKey();
        Appliance appliance = (Appliance)this.m_stages.get(key);
        if (appliance != null) {
            return appliance;
        }
        String error = REZ.getString("lifecycle.stage.key.unknown.error", (Object)this.m_model.getQualifiedName(), (Object)key);
        this.getLogger().error(error);
        throw new IllegalStateException(error);
    }

    private Appliance[] getStageProviders() {
        return this.m_stages.values().toArray(new Appliance[0]);
    }

    public boolean isAssembled() {
        return this.m_assembly.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble() throws AssemblyException {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            Class clazz;
            if (this.isAssembled()) {
                return;
            }
            this.getLogger().debug("assembly phase");
            if (this.m_model.getContextModel() != null && !(clazz = this.m_model.getContextModel().getStrategyClass()).getName().equals("org.apache.avalon.framework.context.Contextualizable")) {
                try {
                    StageDescriptor stage = new StageDescriptor(clazz.getName());
                    this.m_contextProvider = this.m_engine.resolveAppliance(stage);
                }
                catch (Throwable e) {
                    String error = REZ.getString("assembly.context.error", (Object)this.getModel().getQualifiedName(), (Object)clazz.getName());
                    throw new AssemblyException(error, e);
                }
                DeploymentModel model = (DeploymentModel)this.m_contextProvider.getModel();
                Class handler = model.getDeploymentClass();
                if (!(class$org$apache$avalon$activation$lifecycle$ContextualizationHandler == null ? (class$org$apache$avalon$activation$lifecycle$ContextualizationHandler = DefaultAppliance.class$("org.apache.avalon.activation.lifecycle.ContextualizationHandler")) : class$org$apache$avalon$activation$lifecycle$ContextualizationHandler).isAssignableFrom(handler)) {
                    String error = REZ.getString("assembly.context-strategy.bad-class.error", (Object)handler.getName());
                    throw new AssemblyException(error);
                }
                this.registerListener(this.m_contextProvider);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("assigning context provider: " + this.m_contextProvider);
                }
            }
            DependencyModel[] dependencies = this.m_model.getDependencyModels();
            for (int i = 0; i < dependencies.length; ++i) {
                DependencyModel dependency = dependencies[i];
                String key = dependency.getDependency().getKey();
                try {
                    Appliance appliance = this.m_engine.resolveAppliance(dependency);
                    this.registerListener(appliance);
                    this.m_providers.put(key, appliance);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("assigning service provider for key (" + key + "): " + appliance);
                    continue;
                }
                catch (Throwable e) {
                    String error = REZ.getString("assembly.dependency.error", (Object)this.getModel().getQualifiedName(), (Object)key);
                    throw new AssemblyException(error, e);
                }
            }
            StageModel[] stages = this.m_model.getStageModels();
            for (int i = 0; i < stages.length; ++i) {
                StageModel stage = stages[i];
                String key = stage.getStage().getKey();
                try {
                    Appliance appliance = this.m_engine.resolveAppliance(stage);
                    this.registerListener(appliance);
                    this.m_stages.put(key, appliance);
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("assigning stage provider (" + key + "): " + appliance);
                    continue;
                }
                catch (Throwable e) {
                    String error = REZ.getString("assembly.stage.error", (Object)this.getModel().getQualifiedName(), (Object)key);
                    throw new AssemblyException(error, e);
                }
            }
            this.m_assembly.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassemble() {
        DefaultState defaultState = this.m_assembly;
        synchronized (defaultState) {
            if (!this.m_assembly.isEnabled()) {
                String error = REZ.getString("assembly.dissassembly.state.error", (Object)this.getModel().getQualifiedName());
                throw new IllegalStateException(error);
            }
            this.getLogger().debug("dissassembly phase");
            this.m_contextProvider = null;
            this.m_stages.clear();
            this.m_providers.clear();
            this.m_assembly.setEnabled(false);
        }
    }

    public Appliance[] getProviders() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.m_contextProvider != null) {
            list.add(this.m_contextProvider);
        }
        list.addAll(this.m_stages.values());
        list.addAll(this.m_providers.values());
        return list.toArray(new Appliance[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Exception {
        DefaultState defaultState = this.m_deployment;
        synchronized (defaultState) {
            if (this.m_deployment.isEnabled()) {
                return;
            }
            String lifestyle = this.m_model.getType().getInfo().getLifestyle();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("deployment (" + lifestyle + ") [" + this.m_model.getActivationPolicy() + "]");
            }
            if (this.m_contextProvider != null) {
                this.m_contextualization = this.setupContextualizationHandler(this.m_contextProvider);
            }
            this.m_lifestyle = this.createLifestyleHandler(lifestyle);
            this.m_deployment.setEnabled(true);
            if (this.m_model.getActivationPolicy()) {
                Object instance = this.resolve((Object)this);
                if (this.getLogger().isDebugEnabled()) {
                    int id = System.identityHashCode(instance);
                    this.getLogger().debug("activated instance: " + id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommission() {
        DefaultState defaultState = this.m_deployment;
        synchronized (defaultState) {
            if (!this.m_deployment.isEnabled()) {
                return;
            }
            this.getLogger().debug("decommissioning phase");
            if (this.m_lifestyle != null && this.m_lifestyle instanceof Disposable) {
                ((Disposable)this.m_lifestyle).dispose();
            }
            if (this.m_contextProvider != null) {
                this.m_contextProvider.release((Object)this, (Object)this.m_contextualization);
                this.m_contextualization = null;
            }
            this.m_deployment.setEnabled(false);
            this.m_lifestyle = null;
        }
    }

    public Object resolve(Object source) throws Exception {
        return this.resolve(source, new Class[0]);
    }

    public Object resolve(Object source, Class[] ref) throws Exception {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!this.m_deployment.isEnabled()) {
            String error = "Illegal attempt to resolve an service from a non-deployed appliance [" + (Object)((Object)this) + "]. A probably cause is a recursive dependency declaration.";
            this.getLogger().error(error);
            throw new IllegalStateException(error);
        }
        Class[] refs = ref;
        if (refs == null) {
            refs = new Class[]{};
        }
        Object instance = this.m_lifestyle.resolve(source, refs);
        return this.applyAccessStages(instance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object source, Object instance) {
        if (instance == null) {
            return;
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (!this.m_deployment.isEnabled()) {
            return;
        }
        try {
            this.applyAccessStages(instance, false);
        }
        catch (Throwable e) {
            String error = REZ.getString("lifestyle.release.warning");
            this.getLogger().warn(error, e);
        }
        finally {
            this.m_lifestyle.release(source, instance);
        }
    }

    public Object newInstance() throws LifecycleException {
        Class clazz = this.m_model.getDeploymentClass();
        Object instance = null;
        try {
            int id;
            instance = this.createNewInstance(clazz);
            if (this.getLogger().isDebugEnabled()) {
                id = System.identityHashCode(instance);
                this.getLogger().debug("new instance: " + id);
            }
            this.applyLogger(instance);
            this.applyContext(instance);
            this.applyServices(instance);
            this.applyConfiguration(instance);
            this.applyParameters(instance);
            this.applyCreateStages(instance, true);
            this.applyInitialization(instance);
            this.applyStart(instance);
            if (this.getLogger().isDebugEnabled()) {
                id = System.identityHashCode(instance);
                this.getLogger().debug("established: " + id);
            }
            return instance;
        }
        catch (Throwable e) {
            this.destroy(instance);
            String error = REZ.getString("lifestyle.new.error", (Object)this.m_model.getQualifiedName());
            throw new LifecycleException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Object instance) {
        if (instance == null) {
            return;
        }
        int id = System.identityHashCode(instance);
        this.getLogger().debug("component disposal: " + id);
        try {
            this.applyStop(instance);
            this.applyCreateStages(instance, false);
            this.applyDispose(instance);
        }
        catch (Throwable e) {
            this.getLogger().warn("ignoring release stage error", e);
        }
        finally {
            this.getLogger().debug("destroyed instance: " + id);
        }
    }

    public void dispose() {
        this.getLogger().debug("disposal");
    }

    private Object createNewInstance(Class clazz) throws LifecycleException {
        try {
            return clazz.newInstance();
        }
        catch (Throwable e) {
            String error = REZ.getString("lifecycle.instantiation.error", (Object)clazz.getName());
            throw new LifecycleException(error, e);
        }
    }

    private void applyLogger(Object instance) {
        if (instance instanceof LogEnabled) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying logger to: " + id);
            }
            ((LogEnabled)instance).enableLogging(this.m_logger);
        }
    }

    private void applyContext(Object instance) throws Exception {
        if (instance == null) {
            throw new NullPointerException("context");
        }
        ContextModel model = this.m_model.getContextModel();
        if (model == null) {
            return;
        }
        Context context = model.getContext();
        if (this.m_contextualization != null) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying contextualization strategy to: " + id);
            }
            try {
                this.m_contextualization.contextualize(instance, context);
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.contextualization.custom.error", (Object)this.m_model.getQualifiedName());
                throw new LifecycleException(error, e);
            }
        }
        if (instance instanceof Contextualizable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying contextualization to: " + id);
            }
            try {
                ((Contextualizable)instance).contextualize(context);
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.contextualization.component.error", (Object)this.m_model.getQualifiedName());
                throw new LifecycleException(error, e);
            }
        }
    }

    private void applyServices(Object instance) throws Exception {
        if (instance instanceof Serviceable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying service manager to: " + id);
            }
            DefaultServiceManager manager = new DefaultServiceManager(this.getLogger(), this.m_providers);
            ((Serviceable)instance).service((ServiceManager)manager);
        }
    }

    private void applyConfiguration(Object instance) throws Exception {
        if (instance instanceof Configurable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying configuration to: " + id);
            }
            ((Configurable)instance).configure(this.m_model.getConfiguration());
        }
    }

    private void applyParameters(Object instance) throws Exception {
        if (instance instanceof Parameterizable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying parameters to: " + id);
            }
            ((Parameterizable)instance).parameterize(this.m_model.getParameters());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCreateStages(Object instance, boolean flag) throws Exception {
        StageDescriptor[] stages = this.m_model.getType().getStages();
        this.getLogger().debug("stage count: " + stages.length);
        for (int i = 0; i < stages.length; ++i) {
            Creator handler;
            StageDescriptor stage = stages[i];
            Appliance provider = this.getStageProvider(stage);
            Class c = ((DeploymentModel)provider.getModel()).getDeploymentClass();
            this.getLogger().debug("processing create: " + c.getName() + ", [" + (class$org$apache$avalon$lifecycle$Creator == null ? DefaultAppliance.class$("org.apache.avalon.lifecycle.Creator") : class$org$apache$avalon$lifecycle$Creator).isAssignableFrom(c) + "]");
            if ((class$org$apache$avalon$lifecycle$Creator == null ? DefaultAppliance.class$("org.apache.avalon.lifecycle.Creator") : class$org$apache$avalon$lifecycle$Creator).isAssignableFrom(c)) {
                handler = (Creator)provider.resolve((Object)this);
                Context context = this.m_model.getContextModel().getContext();
                try {
                    if (flag) {
                        if (this.getLogger().isDebugEnabled()) {
                            int id = System.identityHashCode(instance);
                            this.getLogger().debug("applying create stage to: " + id);
                        }
                        handler.create(instance, context);
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            int id = System.identityHashCode(instance);
                            this.getLogger().debug("applying destroy stage to: " + id);
                        }
                        handler.destroy(instance, context);
                    }
                }
                catch (Throwable e) {
                    String error = REZ.getString("lifecycle.stage.creator.error", (Object)stage.getKey());
                    if (flag) {
                        throw new LifecycleException(error, e);
                    }
                    this.getLogger().warn(error, e);
                }
                finally {
                    provider.release((Object)this, (Object)handler);
                }
            }
            if (flag && (class$org$apache$avalon$activation$lifecycle$LifecycleCreateExtension == null ? DefaultAppliance.class$("org.apache.avalon.activation.lifecycle.LifecycleCreateExtension") : class$org$apache$avalon$activation$lifecycle$LifecycleCreateExtension).isAssignableFrom(c)) {
                handler = (LifecycleCreateExtension)provider.resolve((Object)this);
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        int id = System.identityHashCode(instance);
                        this.getLogger().debug("applying model create stage to: " + id);
                    }
                    handler.create(this.m_model, stage, instance);
                    continue;
                }
                finally {
                    provider.release((Object)this, (Object)handler);
                }
            }
            if (flag || !(class$org$apache$avalon$activation$lifecycle$LifecycleDestroyExtension == null ? DefaultAppliance.class$("org.apache.avalon.activation.lifecycle.LifecycleDestroyExtension") : class$org$apache$avalon$activation$lifecycle$LifecycleDestroyExtension).isAssignableFrom(c)) continue;
            handler = (LifecycleDestroyExtension)provider.resolve((Object)this);
            try {
                if (this.getLogger().isDebugEnabled()) {
                    int id = System.identityHashCode(instance);
                    this.getLogger().debug("applying model destroy stage to: " + id);
                }
                handler.destroy(this.m_model, stage, instance);
                continue;
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) continue;
                String error = "Ignoring destroy stage error";
                this.getLogger().warn("Ignoring destroy stage error", e);
                continue;
            }
            finally {
                provider.release((Object)this, (Object)handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object applyAccessStages(Object instance, boolean flag) throws Exception {
        StageDescriptor[] stages = this.m_model.getType().getStages();
        for (int i = 0; i < stages.length; ++i) {
            StageDescriptor stage;
            Appliance provider;
            Class c;
            if (!(class$org$apache$avalon$lifecycle$Accessor == null ? DefaultAppliance.class$("org.apache.avalon.lifecycle.Accessor") : class$org$apache$avalon$lifecycle$Accessor).isAssignableFrom(c = ((DeploymentModel)(provider = this.getStageProvider(stage = stages[i])).getModel()).getDeploymentClass())) continue;
            Accessor handler = (Accessor)provider.resolve((Object)this);
            try {
                Context context = this.m_model.getContextModel().getContext();
                if (flag) {
                    if (this.getLogger().isDebugEnabled()) {
                        int id = System.identityHashCode(instance);
                        this.getLogger().debug("applying access stage to: " + id);
                    }
                    handler.access(instance, context);
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    int id = System.identityHashCode(instance);
                    this.getLogger().debug("applying release stage to: " + id);
                }
                handler.release(instance, context);
                continue;
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.stage.accessor.error", (Object)stage.getKey());
                if (flag) {
                    throw new LifecycleException(error, e);
                }
                this.getLogger().warn(error, e);
                continue;
            }
            finally {
                provider.release((Object)this, (Object)handler);
            }
        }
        return instance;
    }

    private void applyInitialization(Object instance) throws LifecycleException {
        if (instance instanceof Initializable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("applying initialization to: " + id);
            }
            try {
                ((Initializable)instance).initialize();
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.initialize.component.error");
                throw new LifecycleException(error, e);
            }
        }
    }

    private void applyStart(Object instance) throws LifecycleException {
        if (instance instanceof Startable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("starting: " + id);
            }
            try {
                ((Startable)instance).start();
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.start.component.error");
                throw new LifecycleException(error, e);
            }
        }
        if (instance instanceof Executable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("executing: " + id);
            }
            try {
                ((Executable)instance).execute();
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.execute.component.error");
                throw new LifecycleException(error, e);
            }
        }
    }

    private void applyStop(Object instance) {
        if (instance instanceof Startable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("stopping: " + id);
            }
            try {
                ((Startable)instance).stop();
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.stop.component.warn");
                this.getLogger().warn(error, e);
            }
        }
    }

    private void applyDispose(Object instance) {
        if (instance instanceof Disposable) {
            if (this.getLogger().isDebugEnabled()) {
                int id = System.identityHashCode(instance);
                this.getLogger().debug("disposing of: " + id);
            }
            try {
                ((Disposable)instance).dispose();
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.dispose.component.warn");
                this.getLogger().warn(error, e);
            }
        }
    }

    private Logger getTargetLogger(LoggingManager logging, DeploymentModel model) {
        if ((class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = DefaultAppliance.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled).isAssignableFrom(model.getDeploymentClass())) {
            String name = model.getQualifiedName();
            CategoriesDirective categories = model.getCategories();
            if (categories != null) {
                logging.addCategories(name, categories);
            }
            return logging.getLoggerForCategory(name);
        }
        return null;
    }

    private ContextualizationHandler setupContextualizationHandler(Appliance appliance) throws Exception {
        if (appliance == null) {
            return null;
        }
        try {
            return (ContextualizationHandler)appliance.resolve((Object)this);
        }
        catch (Throwable e) {
            String error = REZ.getString("deployment.contextualization.custom-resolve.error", (Object)appliance.getModel().getQualifiedName());
            throw new LifecycleException(error, e);
        }
    }

    private LifestyleHandler createLifestyleHandler(String lifestyle) {
        Logger log = this.getLogger();
        if (lifestyle.equals("singleton")) {
            return new SingletonLifestyleHandler(log, this);
        }
        if (lifestyle.equals("thread")) {
            return new ThreadLifestyleHandler(log, this);
        }
        if (lifestyle.equals("pooled")) {
            return new PooledLifestyleHandler(log, this);
        }
        return new TransientLifestyleHandler(log, this);
    }

    private void registerListener(Appliance appliance) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

