/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance.impl;

import org.apache.avalon.activation.appliance.Block;
import org.apache.avalon.composition.model.ContainmentModel;

public class BlockThread
extends Thread {
    private final Block m_block;
    private Throwable m_error;
    private boolean m_started = false;
    private boolean m_stopped = false;
    private boolean m_terminate = false;

    public BlockThread(Block block) throws Exception {
        if (block == null) {
            throw new NullPointerException("block");
        }
        ContainmentModel model = (ContainmentModel)block.getModel();
        ClassLoader classloader = model.getClassLoaderModel().getClassLoader();
        this.setContextClassLoader(classloader);
        this.m_block = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_block.deploy();
        }
        catch (Throwable e) {
            this.m_error = e;
        }
        finally {
            this.m_started = true;
        }
        while (!this.m_terminate) {
            if (null != this.m_error) {
                this.m_terminate = true;
            }
            try {
                Thread.sleep(300L);
            }
            catch (Throwable throwable) {}
        }
        this.m_block.decommission();
        this.m_stopped = true;
    }

    public void decommission() {
        this.m_terminate = true;
    }

    public boolean started() {
        return this.m_started;
    }

    public boolean stopped() {
        return this.m_stopped;
    }

    public Throwable getError() {
        return this.m_error;
    }
}

