package com.atlascopco.admin.controller;

import com.atlascopco.admin.constant.ConstantItem;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.qding.common.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static java.util.regex.Pattern.compile;

/**
 *
 * @author CK
 * @date 2017/11/22
 */

@Controller
public class SystemController {

    private static final Log log = LogFactory.getLog(SystemController.class);


    @Autowired
    private ImgStorageUtil imgStorageUtil;




    /**
     * 上传图片
     *
     * @param request
     * @param response
     * @param model
     * @param file
     * @param module
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) {

        log.info("upload module is " + module);

        if (org.apache.commons.lang.StringUtils.isBlank(module)) {
            log.info("type is null");
        }

        log.info(file.getOriginalFilename());

        try {

            String ext = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + ext;


            String filePath = "/data/img/" + module + "/" + fileName;
//
//            String filePath = "C:\\\\Users\\\\Administrator\\\\Desktop\\\\img" + module + "\" + fileName;
//
            String dirPath = "/data/img/" + module;
//            String dirPath = "C:\\\\Users\\\\Administrator\\\\Desktop\\\\img" + module;


            File dir = new File("/data/img/atlas/" + module);
//            File dir = new File("C:\\\\Users\\\\Administrator\\\\Desktop\\\\img" + module);

            if (dir.exists()) {
                log.info("创建目录" + dirPath + "失败，目标目录已经存在");
            } else {
                //创建目录
                if (dir.mkdirs()) {
                    log.info("创建目录" + dirPath + "成功！");
                } else {
                    log.info("创建目录" + dirPath + "失败！");
                }
            }

            File tempFile = new File(filePath);
            file.transferTo(tempFile);
//            String url = this.imgStorageUtil.imgStorage(null, "img/" + module + "/"
            String url = this.imgStorageUtil.imgStorage(null,  "img/"+module + "/"
                    + fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName
                    + "temp path is " + filePath + " access url is " + url);
            tempFile.delete();
//			log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", "0");

        } catch (Throwable t) {

            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "common/img";
    }


    // 2、邮箱验证码发送
    @RequestMapping(value = "/a/mail", method = RequestMethod.POST)
    public String sendMailVerify(HttpServletRequest request, HttpServletResponse response, ModelMap model, String name,
                                String phone, String message) throws ServiceException, ServiceDaoException {
        log.info( " want send mail  content  is:" + name + phone + message);

        try {

            if (StringUtils.isBlank(name)) {
                log.info(" want send of name " + name +"is  null");

                model.addAttribute("code", -2022);
                return "/common/fail";
            }else {
                //邮箱格式校验
                log.info("mail address verify ");
                Pattern p = compile("^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(\\.([a-zA-Z0-9_-])+)+$");
                Matcher m = p.matcher(ConstantItem.MAIL);
                boolean result = m.matches();
                log.info("mail address verify result : " + result);
                if (result) {
                    log.info("mail address verify OK");
                } else {
                    log.info("mail address verify fail");
                    model.addAttribute("code", -2023);
                    return "/common/success";
                }
            }

            model.addAttribute("code", 0);

        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" send message error of type " );
            model.addAttribute("code", -1);

        }
        return "/common/success";

    }



}
