/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.reflect.GenericSignatureInformationProvider;
import org.aspectj.weaver.reflect.Java14GenericSignatureInformationProvider;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegate;
import org.aspectj.weaver.reflect.ReflectionBasedResolvedMemberImpl;
import org.aspectj.weaver.reflect.ReflectionWorld;

public class ReflectionBasedReferenceTypeDelegateFactory {
    static /* synthetic */ Class class$org$aspectj$weaver$World;

    public static ReflectionBasedReferenceTypeDelegate createDelegate(ReferenceType forReferenceType, World inWorld, ClassLoader usingClassLoader) {
        try {
            ReflectionBasedReferenceTypeDelegate rbrtd;
            Class<?> c = Class.forName(forReferenceType.getName(), false, usingClassLoader);
            if (LangUtil.is15VMOrGreater() && (rbrtd = ReflectionBasedReferenceTypeDelegateFactory.create15Delegate(forReferenceType, c, usingClassLoader, inWorld)) != null) {
                return rbrtd;
            }
            return new ReflectionBasedReferenceTypeDelegate(c, usingClassLoader, inWorld, forReferenceType);
        }
        catch (ClassNotFoundException cnfEx) {
            return null;
        }
    }

    private static ReflectionBasedReferenceTypeDelegate create15Delegate(ReferenceType forReferenceType, Class forClass, ClassLoader usingClassLoader, World inWorld) {
        try {
            Class<?> delegateClass = Class.forName("org.aspectj.weaver.reflect.Java15ReflectionBasedReferenceTypeDelegate");
            ReflectionBasedReferenceTypeDelegate ret = (ReflectionBasedReferenceTypeDelegate)delegateClass.newInstance();
            ret.initialize(forReferenceType, forClass, usingClassLoader, inWorld);
            return ret;
        }
        catch (ClassNotFoundException cnfEx) {
            throw new IllegalStateException("Attempted to create Java 1.5 reflection based delegate but org.aspectj.weaver.reflect.Java15ReflectionBasedReferenceTypeDelegate was not found on classpath");
        }
        catch (InstantiationException insEx) {
            throw new IllegalStateException("Attempted to create Java 1.5 reflection based delegate but InstantiationException: " + insEx + " occured");
        }
        catch (IllegalAccessException illAccEx) {
            throw new IllegalStateException("Attempted to create Java 1.5 reflection based delegate but IllegalAccessException: " + illAccEx + " occured");
        }
    }

    private static GenericSignatureInformationProvider createGenericSignatureProvider(World inWorld) {
        if (LangUtil.is15VMOrGreater()) {
            try {
                Class<?> providerClass = Class.forName("org.aspectj.weaver.reflect.Java15GenericSignatureInformationProvider");
                Constructor<?> cons = providerClass.getConstructor(class$org$aspectj$weaver$World == null ? (class$org$aspectj$weaver$World = ReflectionBasedReferenceTypeDelegateFactory.class$("org.aspectj.weaver.World")) : class$org$aspectj$weaver$World);
                GenericSignatureInformationProvider ret = (GenericSignatureInformationProvider)cons.newInstance(inWorld);
                return ret;
            }
            catch (ClassNotFoundException cnfEx) {
                throw new IllegalStateException("Attempted to create Java 1.5 generic signature provider but org.aspectj.weaver.reflect.Java15GenericSignatureInformationProvider was not found on classpath");
            }
            catch (NoSuchMethodException nsmEx) {
                throw new IllegalStateException("Attempted to create Java 1.5 generic signature provider but: " + nsmEx + " occured");
            }
            catch (InstantiationException insEx) {
                throw new IllegalStateException("Attempted to create Java 1.5 generic signature provider but: " + insEx + " occured");
            }
            catch (InvocationTargetException invEx) {
                throw new IllegalStateException("Attempted to create Java 1.5 generic signature provider but: " + invEx + " occured");
            }
            catch (IllegalAccessException illAcc) {
                throw new IllegalStateException("Attempted to create Java 1.5 generic signature provider but: " + illAcc + " occured");
            }
        }
        return new Java14GenericSignatureInformationProvider();
    }

    public static ResolvedMember createResolvedMember(java.lang.reflect.Member reflectMember, World inWorld) {
        if (reflectMember instanceof Method) {
            return ReflectionBasedReferenceTypeDelegateFactory.createResolvedMethod((Method)reflectMember, inWorld);
        }
        if (reflectMember instanceof Constructor) {
            return ReflectionBasedReferenceTypeDelegateFactory.createResolvedConstructor((Constructor)reflectMember, inWorld);
        }
        return ReflectionBasedReferenceTypeDelegateFactory.createResolvedField((Field)reflectMember, inWorld);
    }

    public static ResolvedMember createResolvedMethod(Method aMethod, World inWorld) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.METHOD, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getDeclaringClass(), (ReflectionWorld)inWorld), aMethod.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getReturnType(), (ReflectionWorld)inWorld), aMethod.getName(), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getParameterTypes(), inWorld), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getExceptionTypes(), inWorld), aMethod);
        if (inWorld instanceof ReflectionWorld) {
            ret.setAnnotationFinder(((ReflectionWorld)inWorld).getAnnotationFinder());
        }
        ret.setGenericSignatureInformationProvider(ReflectionBasedReferenceTypeDelegateFactory.createGenericSignatureProvider(inWorld));
        return ret;
    }

    public static ResolvedMember createResolvedAdviceMember(Method aMethod, World inWorld) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.ADVICE, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getDeclaringClass(), (ReflectionWorld)inWorld), aMethod.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getReturnType(), (ReflectionWorld)inWorld), aMethod.getName(), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getParameterTypes(), inWorld), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getExceptionTypes(), inWorld), aMethod);
        if (inWorld instanceof ReflectionWorld) {
            ret.setAnnotationFinder(((ReflectionWorld)inWorld).getAnnotationFinder());
        }
        ret.setGenericSignatureInformationProvider(ReflectionBasedReferenceTypeDelegateFactory.createGenericSignatureProvider(inWorld));
        return ret;
    }

    public static ResolvedMember createStaticInitMember(Class forType, World inWorld) {
        return new ResolvedMemberImpl(Member.STATIC_INITIALIZATION, ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(forType, (ReflectionWorld)inWorld), 8, ResolvedType.VOID, "<clinit>", new UnresolvedType[0], new UnresolvedType[0]);
    }

    public static ResolvedMember createResolvedConstructor(Constructor aConstructor, World inWorld) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.CONSTRUCTOR, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aConstructor.getDeclaringClass(), (ReflectionWorld)inWorld), aConstructor.getModifiers(), (UnresolvedType)ResolvedType.VOID, "<init>", (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aConstructor.getParameterTypes(), inWorld), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aConstructor.getExceptionTypes(), inWorld), aConstructor);
        if (inWorld instanceof ReflectionWorld) {
            ret.setAnnotationFinder(((ReflectionWorld)inWorld).getAnnotationFinder());
        }
        ret.setGenericSignatureInformationProvider(ReflectionBasedReferenceTypeDelegateFactory.createGenericSignatureProvider(inWorld));
        return ret;
    }

    public static ResolvedMember createResolvedField(Field aField, World inWorld) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.FIELD, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aField.getDeclaringClass(), (ReflectionWorld)inWorld), aField.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aField.getType(), (ReflectionWorld)inWorld), aField.getName(), new UnresolvedType[0], aField);
        if (inWorld instanceof ReflectionWorld) {
            ret.setAnnotationFinder(((ReflectionWorld)inWorld).getAnnotationFinder());
        }
        ret.setGenericSignatureInformationProvider(ReflectionBasedReferenceTypeDelegateFactory.createGenericSignatureProvider(inWorld));
        return ret;
    }

    public static ResolvedMember createHandlerMember(Class exceptionType, Class inType, World inWorld) {
        return new ResolvedMemberImpl(Member.HANDLER, ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(inType, (ReflectionWorld)inWorld), 8, "<catch>", "(" + inWorld.resolve(exceptionType.getName()).getSignature() + ")V");
    }

    public static ResolvedType resolveTypeInWorld(Class aClass, World aWorld) {
        String className = aClass.getName();
        if (aClass.isArray()) {
            return aWorld.resolve(UnresolvedType.forSignature(className.replace('.', '/')));
        }
        return aWorld.resolve(className);
    }

    private static ResolvedType toResolvedType(Class aClass, ReflectionWorld aWorld) {
        return aWorld.resolve(aClass);
    }

    private static ResolvedType[] toResolvedTypeArray(Class[] classes, World inWorld) {
        ResolvedType[] ret = new ResolvedType[classes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((ReflectionWorld)inWorld).resolve(classes[i]);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

