/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.BcelAdvice;

public class AsmRelationshipProvider {
    protected static AsmRelationshipProvider INSTANCE = new AsmRelationshipProvider();
    public static final String ADVISES = "advises";
    public static final String ADVISED_BY = "advised by";
    public static final String DECLARES_ON = "declares on";
    public static final String DECLAREDY_BY = "declared by";
    public static final String SOFTENS = "softens";
    public static final String SOFTENED_BY = "softened by";
    public static final String MATCHED_BY = "matched by";
    public static final String MATCHES_DECLARE = "matches declare";
    public static final String INTER_TYPE_DECLARES = "declared on";
    public static final String INTER_TYPE_DECLARED_BY = "aspect declarations";
    public static final String ANNOTATES = "annotates";
    public static final String ANNOTATED_BY = "annotated by";

    public void checkerMunger(IHierarchy model, Shadow shadow, Checker checker) {
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        if (shadow.getSourceLocation() == null || checker.getSourceLocation() == null) {
            return;
        }
        IProgramElement targetNode = this.getNode(AsmManager.getDefault().getHierarchy(), shadow);
        String sourceHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(checker.getSourceLocation().getSourceFile(), checker.getSourceLocation().getLine(), checker.getSourceLocation().getColumn(), checker.getSourceLocation().getOffset());
        String targetHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(shadow.getSourceLocation().getSourceFile(), shadow.getSourceLocation().getLine(), shadow.getSourceLocation().getColumn(), shadow.getSourceLocation().getOffset());
        IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
        if (sourceHandle != null && targetHandle != null) {
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE, MATCHED_BY, false, true);
            foreward.addTarget(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE, MATCHES_DECLARE, false, true);
            if (back != null && back.getTargets() != null) {
                back.addTarget(sourceHandle);
            }
        }
    }

    public void addRelationship(ResolvedType onType, ResolvedTypeMunger munger, ResolvedType originatingAspect) {
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        String sourceHandle = "";
        sourceHandle = munger.getSourceLocation() != null ? AsmManager.getDefault().getHandleProvider().createHandleIdentifier(munger.getSourceLocation().getSourceFile(), munger.getSourceLocation().getLine(), munger.getSourceLocation().getColumn(), munger.getSourceLocation().getOffset()) : AsmManager.getDefault().getHandleProvider().createHandleIdentifier(originatingAspect.getSourceLocation().getSourceFile(), originatingAspect.getSourceLocation().getLine(), originatingAspect.getSourceLocation().getColumn(), originatingAspect.getSourceLocation().getOffset());
        if (originatingAspect.getSourceLocation() != null) {
            String targetHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(onType.getSourceLocation().getSourceFile(), onType.getSourceLocation().getLine(), onType.getSourceLocation().getColumn(), onType.getSourceLocation().getOffset());
            IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
            if (sourceHandle != null && targetHandle != null) {
                IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARES, false, true);
                foreward.addTarget(targetHandle);
                IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARED_BY, false, true);
                back.addTarget(sourceHandle);
            }
        }
    }

    public void addDeclareParentsRelationship(ISourceLocation decp, ResolvedType targetType, List newParents) {
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        String sourceHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(decp.getSourceFile(), decp.getLine(), decp.getColumn(), decp.getOffset());
        IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForHandle(sourceHandle);
        String targetHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(targetType.getSourceLocation().getSourceFile(), targetType.getSourceLocation().getLine(), targetType.getSourceLocation().getColumn(), targetType.getSourceLocation().getOffset());
        IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
        if (sourceHandle != null && targetHandle != null) {
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARES, false, true);
            foreward.addTarget(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, INTER_TYPE_DECLARED_BY, false, true);
            back.addTarget(sourceHandle);
        }
    }

    public void addDeclareAnnotationRelationship(ISourceLocation declareAnnotationLocation, ISourceLocation annotatedLocation) {
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        String sourceHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(declareAnnotationLocation.getSourceFile(), declareAnnotationLocation.getLine(), declareAnnotationLocation.getColumn(), declareAnnotationLocation.getOffset());
        IProgramElement declareAnnotationPE = AsmManager.getDefault().getHierarchy().findElementForHandle(sourceHandle);
        String targetHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(annotatedLocation.getSourceFile(), annotatedLocation.getLine(), annotatedLocation.getColumn(), annotatedLocation.getOffset());
        IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
        if (sourceHandle != null && targetHandle != null) {
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATES, false, true);
            foreward.addTarget(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATED_BY, false, true);
            back.addTarget(sourceHandle);
        }
    }

    public void adviceMunger(IHierarchy model, Shadow shadow, ShadowMunger munger) {
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        if (munger instanceof Advice) {
            Advice advice = (Advice)munger;
            if (advice.getKind().isPerEntry() || advice.getKind().isCflow()) {
                return;
            }
            IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
            IProgramElement targetNode = this.getNode(AsmManager.getDefault().getHierarchy(), shadow);
            boolean runtimeTest = ((BcelAdvice)munger).hasDynamicTests();
            IProgramElement.ExtraInformation ai = new IProgramElement.ExtraInformation();
            String adviceHandle = advice.getHandle();
            AdviceKind ak = ((Advice)munger).getKind();
            ai.setExtraAdviceInformation(ak.getName());
            IProgramElement adviceElement = AsmManager.getDefault().getHierarchy().findElementForHandle(adviceHandle);
            adviceElement.setExtraInfo(ai);
            if (adviceHandle != null && targetNode != null && targetNode != null) {
                String targetHandle = targetNode.getHandleIdentifier();
                if (advice.getKind().equals(AdviceKind.Softener)) {
                    IRelationship back;
                    IRelationship foreward = mapper.get(adviceHandle, IRelationship.Kind.DECLARE_SOFT, SOFTENS, runtimeTest, true);
                    if (foreward != null) {
                        foreward.addTarget(targetHandle);
                    }
                    if ((back = mapper.get(targetHandle, IRelationship.Kind.DECLARE, SOFTENED_BY, runtimeTest, true)) != null) {
                        back.addTarget(adviceHandle);
                    }
                } else {
                    IRelationship back;
                    IRelationship foreward = mapper.get(adviceHandle, IRelationship.Kind.ADVICE, ADVISES, runtimeTest, true);
                    if (foreward != null) {
                        foreward.addTarget(targetHandle);
                    }
                    if ((back = mapper.get(targetHandle, IRelationship.Kind.ADVICE, ADVISED_BY, runtimeTest, true)) != null) {
                        back.addTarget(adviceHandle);
                    }
                }
            }
        }
    }

    protected IProgramElement getNode(IHierarchy model, Shadow shadow) {
        Member enclosingMember = shadow.getEnclosingCodeSignature();
        IProgramElement enclosingNode = this.lookupMember(model, enclosingMember);
        if (enclosingNode == null) {
            Lint.Kind err = shadow.getIWorld().getLint().shadowNotInStructure;
            if (err.isEnabled()) {
                err.signal(shadow.toString(), shadow.getSourceLocation());
            }
            return null;
        }
        Member shadowSig = shadow.getSignature();
        if (!shadowSig.equals(enclosingMember)) {
            IProgramElement bodyNode = this.findOrCreateCodeNode(enclosingNode, shadowSig, shadow);
            return bodyNode;
        }
        return enclosingNode;
    }

    private boolean sourceLinesMatch(ISourceLocation loc1, ISourceLocation loc2) {
        return loc1.getLine() == loc2.getLine();
    }

    private IProgramElement findOrCreateCodeNode(IProgramElement enclosingNode, Member shadowSig, Shadow shadow) {
        Iterator it = enclosingNode.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (!shadowSig.getName().equals(node.getBytecodeName()) || !shadowSig.getSignature().equals(node.getBytecodeSignature()) || !this.sourceLinesMatch(node.getSourceLocation(), shadow.getSourceLocation())) continue;
            return node;
        }
        ISourceLocation sl = shadow.getSourceLocation();
        SourceLocation peLoc = new SourceLocation(enclosingNode.getSourceLocation().getSourceFile(), sl.getLine());
        peLoc.setOffset(sl.getOffset());
        ProgramElement peNode = new ProgramElement(shadow.toString(), IProgramElement.Kind.CODE, peLoc, 0, "", new ArrayList());
        peNode.setBytecodeName(shadowSig.getName());
        peNode.setBytecodeSignature(shadowSig.getSignature());
        enclosingNode.addChild(peNode);
        return peNode;
    }

    protected IProgramElement lookupMember(IHierarchy model, Member member) {
        UnresolvedType declaringType = member.getDeclaringType();
        IProgramElement classNode = model.findElementForType(declaringType.getPackageName(), declaringType.getClassName());
        return this.findMemberInClass(classNode, member);
    }

    protected IProgramElement findMemberInClass(IProgramElement classNode, Member member) {
        if (classNode == null) {
            return null;
        }
        Iterator it = classNode.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (!member.getName().equals(node.getBytecodeName()) || !member.getSignature().equals(node.getBytecodeSignature())) continue;
            return node;
        }
        return classNode;
    }

    public static AsmRelationshipProvider getDefault() {
        return INSTANCE;
    }

    public static void setDefault(AsmRelationshipProvider instance) {
        INSTANCE = instance;
    }

    public void addDeclareAnnotationRelationship(ISourceLocation sourceLocation, String typename, Method method) {
        IProgramElement typeElem;
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        String pkg = null;
        String type = typename;
        int packageSeparator = typename.lastIndexOf(".");
        if (packageSeparator != -1) {
            pkg = typename.substring(0, packageSeparator);
            type = typename.substring(packageSeparator + 1);
        }
        if ((typeElem = AsmManager.getDefault().getHierarchy().findElementForType(pkg, type)) == null) {
            return;
        }
        StringBuffer parmString = new StringBuffer("(");
        Type[] args = method.getArgumentTypes();
        for (int i = 0; i < args.length; ++i) {
            Type type2 = args[i];
            String s = Utility.signatureToString(type2.getSignature());
            if (s.lastIndexOf(".") != -1) {
                s = s.substring(s.lastIndexOf(".") + 1);
            }
            parmString.append(s);
            if (i + 1 >= args.length) continue;
            parmString.append(",");
        }
        parmString.append(")");
        IProgramElement methodElem = null;
        if (method.getName().startsWith("<init>")) {
            methodElem = AsmManager.getDefault().getHierarchy().findElementForSignature(typeElem, IProgramElement.Kind.CONSTRUCTOR, type + parmString);
            if (methodElem == null && args.length == 0) {
                methodElem = typeElem;
            }
        } else {
            methodElem = AsmManager.getDefault().getHierarchy().findElementForSignature(typeElem, IProgramElement.Kind.METHOD, method.getName() + parmString);
        }
        if (methodElem == null) {
            return;
        }
        try {
            String sourceHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(sourceLocation.getSourceFile(), sourceLocation.getLine(), sourceLocation.getColumn(), sourceLocation.getOffset());
            String targetHandle = methodElem.getHandleIdentifier();
            IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
            if (sourceHandle != null && targetHandle != null) {
                IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATES, false, true);
                foreward.addTarget(targetHandle);
                IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATED_BY, false, true);
                back.addTarget(sourceHandle);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void addDeclareAnnotationRelationship(ISourceLocation sourceLocation, String typename, Field field) {
        IProgramElement typeElem;
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        String pkg = null;
        String type = typename;
        int packageSeparator = typename.lastIndexOf(".");
        if (packageSeparator != -1) {
            pkg = typename.substring(0, packageSeparator);
            type = typename.substring(packageSeparator + 1);
        }
        if ((typeElem = AsmManager.getDefault().getHierarchy().findElementForType(pkg, type)) == null) {
            return;
        }
        IProgramElement fieldElem = AsmManager.getDefault().getHierarchy().findElementForSignature(typeElem, IProgramElement.Kind.FIELD, field.getName());
        if (fieldElem == null) {
            return;
        }
        String sourceHandle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(sourceLocation.getSourceFile(), sourceLocation.getLine(), sourceLocation.getColumn(), sourceLocation.getOffset());
        String targetHandle = fieldElem.getHandleIdentifier();
        IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
        if (sourceHandle != null && targetHandle != null) {
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATES, false, true);
            foreward.addTarget(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE_INTER_TYPE, ANNOTATED_BY, false, true);
            back.addTarget(sourceHandle);
        }
    }
}

