/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.intercept.event;

import net.sf.acegisecurity.intercept.event.AuthenticationCredentialsNotFoundEvent;
import net.sf.acegisecurity.intercept.event.AuthenticationFailureEvent;
import net.sf.acegisecurity.intercept.event.AuthorizationFailureEvent;
import net.sf.acegisecurity.intercept.event.AuthorizedEvent;
import net.sf.acegisecurity.intercept.event.PublicInvocationEvent;
import net.sf.acegisecurity.intercept.event.SecurityInterceptionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class LoggerListener
implements ApplicationListener {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$intercept$event$LoggerListener == null ? (class$net$sf$acegisecurity$intercept$event$LoggerListener = LoggerListener.class$("net.sf.acegisecurity.intercept.event.LoggerListener")) : class$net$sf$acegisecurity$intercept$event$LoggerListener));
    static /* synthetic */ Class class$net$sf$acegisecurity$intercept$event$LoggerListener;

    public void onApplicationEvent(ApplicationEvent event) {
        SecurityInterceptionEvent authEvent;
        if (event instanceof AuthenticationCredentialsNotFoundEvent) {
            authEvent = (AuthenticationCredentialsNotFoundEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Security interception failed due to: " + (Object)((Object)((AuthenticationCredentialsNotFoundEvent)authEvent).getCredentialsNotFoundException()) + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthenticationCredentialsNotFoundEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof AuthenticationFailureEvent) {
            authEvent = (AuthenticationFailureEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Security authentication failed due to: " + (Object)((Object)((AuthenticationFailureEvent)authEvent).getAuthenticationException()) + "; for authentication request: " + ((AuthenticationFailureEvent)authEvent).getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthenticationFailureEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof AuthorizationFailureEvent) {
            authEvent = (AuthorizationFailureEvent)event;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Security authorization failed due to: " + (Object)((Object)((AuthorizationFailureEvent)authEvent).getAccessDeniedException()) + "; authenticated principal: " + ((AuthorizationFailureEvent)authEvent).getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthorizationFailureEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof AuthorizedEvent) {
            authEvent = (AuthorizedEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Security authorized for authenticated principal: " + ((AuthorizedEvent)authEvent).getAuthentication() + "; secure object: " + authEvent.getSource() + "; configuration attributes: " + ((AuthorizedEvent)authEvent).getConfigAttributeDefinition()));
            }
        }
        if (event instanceof PublicInvocationEvent) {
            authEvent = (PublicInvocationEvent)event;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Security interception not required for public secure object: " + authEvent.getSource()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

