/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.frascati.implementation.spring;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.SpringImplementation;
import org.objectweb.fractal.api.Component;
import org.ow2.frascati.assembly.factory.api.ProcessingContext;
import org.ow2.frascati.assembly.factory.api.ProcessorException;
import org.ow2.frascati.assembly.factory.processor.AbstractCompositeBasedImplementationProcessor;
import org.ow2.frascati.implementation.spring.ParentApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaImplementationSpringProcessor
extends AbstractCompositeBasedImplementationProcessor<SpringImplementation, ClassPathXmlApplicationContext> {
    protected final void toStringBuilder(SpringImplementation springImplementation, StringBuilder sb) {
        sb.append("sca:implementation.spring");
        ScaImplementationSpringProcessor.append((StringBuilder)sb, (String)"location", (String)springImplementation.getLocation());
        super.toStringBuilder((Implementation)springImplementation, sb);
    }

    protected final void doCheck(SpringImplementation springImplementation, ProcessingContext processingContext) throws ProcessorException {
        String springImplementationLocation = springImplementation.getLocation();
        if (springImplementationLocation == null || springImplementationLocation.equals("")) {
            this.error(processingContext, (EObject)springImplementation, new String[]{"The attribute 'location' must be set"});
        } else if (processingContext.getResource(springImplementationLocation) == null) {
            this.error(processingContext, (EObject)springImplementation, new String[]{"Location '", springImplementationLocation, "' not found"});
        }
        this.checkImplementation((Implementation)springImplementation, processingContext);
    }

    protected final void doInstantiate(SpringImplementation springImplementation, ProcessingContext processingContext) throws ProcessorException {
        String springLocation = springImplementation.getLocation();
        this.log.finer("Create an SCA component with the Spring implementation " + springLocation + " and the Fractal component type " + this.getFractalComponentType((EObject)springImplementation, processingContext).toString());
        Component component = this.createFractalComposite((Implementation)springImplementation, processingContext);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{springLocation}, (ApplicationContext)new ParentApplicationContext(component));
        context.setClassLoader(processingContext.getClassLoader());
        this.connectFractalComposite((Implementation)springImplementation, processingContext, context);
    }

    protected final Object getService(ClassPathXmlApplicationContext context, String name, Class<?> interfaze) throws Exception {
        return context.getBean(name);
    }

    protected final void setReference(ClassPathXmlApplicationContext context, String name, Object delegate, Class<?> interfaze) throws Exception {
    }

    public final String getProcessorID() {
        return ScaImplementationSpringProcessor.getID((EClass)ScaPackage.Literals.SPRING_IMPLEMENTATION);
    }
}

