/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.modules.Module;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ContextManager {
    private final List<SetupAction> setupActions;
    private final ArquillianConfig config;

    ContextManager(ArquillianConfig config, List<SetupAction> setupActions) {
        this.config = config;
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>(setupActions);
        Collections.sort(actions, new Comparator<SetupAction>(){

            @Override
            public int compare(SetupAction arg0, SetupAction arg1) {
                return arg0.priority() > arg1.priority() ? -1 : (arg0.priority() == arg1.priority() ? 0 : 1);
            }
        });
        this.setupActions = Collections.unmodifiableList(actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup(Map<String, Object> properties) {
        ArrayList<SetupAction> successfulActions = new ArrayList<SetupAction>();
        DeploymentUnit depUnit = this.config.getDeploymentUnit();
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        ClassLoader tccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
        try {
            for (SetupAction action : this.setupActions) {
                try {
                    action.setup(properties);
                    successfulActions.add(action);
                }
                catch (Throwable e) {
                    for (SetupAction s : successfulActions) {
                        try {
                            s.teardown(properties);
                        }
                        catch (Throwable throwable) {}
                    }
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void teardown(Map<String, Object> properties) {
        Throwable exceptionToThrow = null;
        ListIterator<SetupAction> itr = this.setupActions.listIterator(this.setupActions.size());
        DeploymentUnit depUnit = this.config.getDeploymentUnit();
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        ClassLoader tccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
        try {
            while (itr.hasPrevious()) {
                SetupAction action = itr.previous();
                try {
                    action.teardown(properties);
                }
                catch (Throwable e) {
                    if (exceptionToThrow != null) continue;
                    exceptionToThrow = e;
                }
            }
            if (exceptionToThrow == null) return;
            throw new RuntimeException(exceptionToThrow);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
        }
    }
}

