/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jsr303;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jsr303.JSR303Validation;
import org.wicketstuff.jsr303.ViolationErrorBuilder;
import org.wicketstuff.jsr303.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValidator<T>
implements INullAcceptingValidator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final String propertyExpression;
    private final FormComponent<T> fc;
    private static volatile transient Logger _transient_logger = LoggerFactory.getLogger(PropertyValidator.class);

    public void validate(IValidatable<T> validatable) {
        if (this.propertyExpression == null || this.propertyExpression.trim().length() == 0) {
            return;
        }
        if (this.hasExclusionBehaviour()) {
            return;
        }
        Object value = validatable.getValue();
        Set violations = JSR303Validation.getValidator().validateValue(this.beanClass, this.propertyExpression, value, new Class[0]);
        for (Object v : violations) {
            validatable.error((IValidationError)this.wrap((ConstraintViolation)v).createError());
        }
    }

    private <V> ViolationErrorBuilder.Property<V> wrap(ConstraintViolation<V> violation) {
        return new ViolationErrorBuilder.Property<V>(violation);
    }

    public PropertyValidator(AbstractPropertyModel<?> apm, FormComponent<T> componentToApplyTo) {
        this.fc = componentToApplyTo;
        Assert.parameterNotNull(apm, "apm");
        this.beanClass = apm.getTarget().getClass();
        this.propertyExpression = apm.getPropertyExpression();
    }

    private boolean hasExclusionBehaviour() {
        List behaviors = this.fc.getBehaviors();
        for (Behavior iBehavior : behaviors) {
            if (!(iBehavior instanceof Exclude)) continue;
            return true;
        }
        return false;
    }

    public static final Logger log() {
        if (_transient_logger == null) {
            _transient_logger = LoggerFactory.getLogger(PropertyValidator.class);
        }
        return _transient_logger;
    }

    public static class Exclude
    extends Behavior {
        private static final long serialVersionUID = 1L;
    }
}

