/*
 * Decompiled with CFR 0.152.
 */
package org.weixin4j.spring;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.weixin4j.WeixinBuilder;
import org.weixin4j.WeixinConfig;
import org.weixin4j.WeixinPayConfig;
import org.weixin4j.factory.WeixinFactory;
import org.weixin4j.loader.ITicketLoader;
import org.weixin4j.loader.ITokenLoader;

public class WeixinFactoryBean
implements FactoryBean<WeixinFactory>,
InitializingBean {
    private WeixinConfig weixinConfig;
    private WeixinPayConfig weixinPayConfig;
    private WeixinFactory weixinFactory;
    private ITokenLoader tokenLoader;
    private ITicketLoader ticketLoader;

    public void setWeixinConfig(WeixinConfig weixinConfig) {
        this.weixinConfig = weixinConfig;
    }

    public void setWeixinPayConfig(WeixinPayConfig weixinPayConfig) {
        this.weixinPayConfig = weixinPayConfig;
    }

    public void setTokenLoader(ITokenLoader tokenLoader) {
        this.tokenLoader = tokenLoader;
    }

    public void setTicketLoader(ITicketLoader ticketLoader) {
        this.ticketLoader = ticketLoader;
    }

    public Class<?> getObjectType() {
        return this.weixinFactory == null ? WeixinFactory.class : this.weixinFactory.getClass();
    }

    public WeixinFactory getObject() throws Exception {
        System.out.println("WeixinFactoryBean...getObject...");
        if (this.weixinFactory == null) {
            this.afterPropertiesSet();
        }
        return this.weixinFactory;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        System.out.println("WeixinFactoryBean...afterPropertiesSet...");
        this.weixinFactory = this.buildWeixinFactory();
    }

    private WeixinFactory buildWeixinFactory() {
        System.out.println("WeixinFactoryBean...buildWeixinFactory...");
        WeixinBuilder weixinBuilder = this.weixinConfig != null ? (this.weixinPayConfig != null ? WeixinBuilder.newInstance((WeixinConfig)this.weixinConfig, (WeixinPayConfig)this.weixinPayConfig) : WeixinBuilder.newInstance((WeixinConfig)this.weixinConfig)) : (this.weixinPayConfig != null ? WeixinBuilder.newInstance((WeixinPayConfig)this.weixinPayConfig) : WeixinBuilder.newInstance());
        if (this.tokenLoader != null) {
            System.out.println("WeixinFactoryBean.buildWeixinFactory." + this.tokenLoader.getClass().getName());
            weixinBuilder.setTokenLoader(this.tokenLoader);
        }
        if (this.ticketLoader != null) {
            System.out.println("WeixinFactoryBean.buildWeixinFactory." + this.ticketLoader.getClass().getName());
            weixinBuilder.setTicketLoader(this.ticketLoader);
        }
        return weixinBuilder.buildWeixinFactory();
    }
}

