/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.orm.hibernate.util;

import java.util.Collection;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;
import org.unitils.core.Unitils;
import org.unitils.orm.common.spring.OrmSpringSupport;
import org.unitils.orm.common.util.ConfiguredOrmPersistenceUnit;
import org.unitils.spring.SpringModule;

public class HibernateSpringSupport
implements OrmSpringSupport<SessionFactory, Configuration> {
    @Override
    public boolean isPersistenceUnitConfiguredInSpring(Object testObject) {
        return this.getSessionFactoryBean(testObject) != null;
    }

    @Override
    public ConfiguredOrmPersistenceUnit<SessionFactory, Configuration> getConfiguredPersistenceUnit(Object testObject) {
        LocalSessionFactoryBean factoryBean = this.getSessionFactoryBean(testObject);
        SessionFactory entityManagerFactory = factoryBean.getObject();
        Configuration hibernateConfiguration = factoryBean.getConfiguration();
        return new ConfiguredOrmPersistenceUnit<SessionFactory, Configuration>(entityManagerFactory, hibernateConfiguration);
    }

    protected LocalSessionFactoryBean getSessionFactoryBean(Object testObject) {
        if (!this.getSpringModule().isApplicationContextConfiguredFor(testObject)) {
            return null;
        }
        Collection entityManagerFactoryBeans = this.getSpringModule().getApplicationContext(testObject).getBeansOfType(LocalSessionFactoryBean.class).values();
        if (entityManagerFactoryBeans.size() == 0) {
            return null;
        }
        return (LocalSessionFactoryBean)entityManagerFactoryBeans.iterator().next();
    }

    protected SpringModule getSpringModule() {
        return (SpringModule)Unitils.getInstance().getModulesRepository().getModuleOfType(SpringModule.class);
    }
}

