/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

class Jackson2Tokenizer
implements Function<DataBuffer, Flux<TokenBuffer>> {
    private final JsonParser parser;
    private final boolean tokenizeArrayElements;
    private TokenBuffer tokenBuffer;
    private int objectDepth;
    private int arrayDepth;
    private final ByteArrayFeeder inputFeeder;

    public Jackson2Tokenizer(JsonParser parser, boolean tokenizeArrayElements) {
        Assert.notNull((Object)parser, (String)"'parser' must not be null");
        this.parser = parser;
        this.tokenizeArrayElements = tokenizeArrayElements;
        this.tokenBuffer = new TokenBuffer(parser);
        this.inputFeeder = (ByteArrayFeeder)this.parser.getNonBlockingInputFeeder();
    }

    @Override
    public Flux<TokenBuffer> apply(DataBuffer dataBuffer) {
        byte[] bytes = new byte[dataBuffer.readableByteCount()];
        dataBuffer.read(bytes);
        DataBufferUtils.release((DataBuffer)dataBuffer);
        try {
            JsonToken token;
            this.inputFeeder.feedInput(bytes, 0, bytes.length);
            ArrayList<TokenBuffer> result = new ArrayList<TokenBuffer>();
            while ((token = this.parser.nextToken()) != JsonToken.NOT_AVAILABLE) {
                this.updateDepth(token);
                if (!this.tokenizeArrayElements) {
                    this.processTokenNormal(token, result);
                    continue;
                }
                this.processTokenArray(token, result);
            }
            return Flux.fromIterable(result);
        }
        catch (JsonProcessingException ex) {
            return Flux.error((Throwable)new DecodingException("JSON decoding error: " + ex.getOriginalMessage(), (Throwable)ex));
        }
        catch (Exception ex) {
            return Flux.error((Throwable)ex);
        }
    }

    private void updateDepth(JsonToken token) {
        switch (token) {
            case START_OBJECT: {
                ++this.objectDepth;
                break;
            }
            case END_OBJECT: {
                --this.objectDepth;
                break;
            }
            case START_ARRAY: {
                ++this.arrayDepth;
                break;
            }
            case END_ARRAY: {
                --this.arrayDepth;
            }
        }
    }

    private void processTokenNormal(JsonToken token, List<TokenBuffer> result) throws IOException {
        this.tokenBuffer.copyCurrentEvent(this.parser);
        if ((token == JsonToken.END_OBJECT || token == JsonToken.END_ARRAY) && this.objectDepth == 0 && this.arrayDepth == 0) {
            result.add(this.tokenBuffer);
            this.tokenBuffer = new TokenBuffer(this.parser);
        }
    }

    private void processTokenArray(JsonToken token, List<TokenBuffer> result) throws IOException {
        if (!this.isTopLevelArrayToken(token)) {
            this.tokenBuffer.copyCurrentEvent(this.parser);
        }
        if (token == JsonToken.END_OBJECT && this.objectDepth == 0 && (this.arrayDepth == 1 || this.arrayDepth == 0)) {
            result.add(this.tokenBuffer);
            this.tokenBuffer = new TokenBuffer(this.parser);
        }
    }

    private boolean isTopLevelArrayToken(JsonToken token) {
        return this.objectDepth == 0 && (token == JsonToken.START_ARRAY && this.arrayDepth == 1 || token == JsonToken.END_ARRAY && this.arrayDepth == 0);
    }

    public void endOfInput() {
        this.inputFeeder.endOfInput();
    }
}

