/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class RequestResultMatchers {
    protected RequestResultMatchers() {
    }

    public ResultMatcher asyncStarted() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                AssertionErrors.assertEquals("Async started", true, request.isAsyncStarted());
            }
        };
    }

    public ResultMatcher asyncNotStarted() {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                AssertionErrors.assertEquals("Async started", false, request.isAsyncStarted());
            }
        };
    }

    public <T> ResultMatcher asyncResult(final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                AssertionErrors.assertEquals("Async started", true, request.isAsyncStarted());
                MatcherAssertionErrors.assertThat("Async result", result.getAsyncResult(), matcher);
            }
        };
    }

    public <T> ResultMatcher asyncResult(final Object expectedResult) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MockHttpServletRequest request = result.getRequest();
                AssertionErrors.assertEquals("Async started", true, request.isAsyncStarted());
                AssertionErrors.assertEquals("Async result", expectedResult, result.getAsyncResult());
            }
        };
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Object value = result.getRequest().getAttribute(name);
                MatcherAssertionErrors.assertThat("Request attribute", value, matcher);
            }
        };
    }

    public <T> ResultMatcher attribute(final String name, final Object expectedValue) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Request attribute", expectedValue, result.getRequest().getAttribute(name));
            }
        };
    }

    public <T> ResultMatcher sessionAttribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                Object value = result.getRequest().getSession().getAttribute(name);
                MatcherAssertionErrors.assertThat("Request attribute", value, matcher);
            }
        };
    }

    public <T> ResultMatcher sessionAttribute(final String name, final Object value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Request attribute", value, result.getRequest().getSession().getAttribute(name));
            }
        };
    }
}

