/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.charset.Charset;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringRedisSerializer
implements RedisSerializer<String> {
    private final Charset charset;

    public StringRedisSerializer() {
        this(Charset.forName("UTF8"));
    }

    public StringRedisSerializer(Charset charset) {
        Assert.notNull((Object)charset);
        this.charset = charset;
    }

    @Override
    public String deserialize(byte[] bytes) {
        return bytes == null ? null : new String(bytes, this.charset);
    }

    @Override
    public byte[] serialize(String string) {
        return string == null ? null : string.getBytes(this.charset);
    }
}

