/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.jedis.JedisUtils;
import org.springframework.util.ReflectionUtils;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BinaryTransaction;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisConnection
implements RedisConnection {
    private static final Field CLIENT_FIELD = ReflectionUtils.findField(BinaryJedis.class, (String)"client", Client.class);
    private final Jedis jedis;
    private final Client client;
    private final BinaryTransaction transaction;
    private final Pool<Jedis> pool;
    private boolean broken = false;
    private volatile JedisSubscription subscription;
    private volatile Pipeline pipeline;
    private final int dbIndex;

    public JedisConnection(Jedis jedis) {
        this(jedis, null, 0);
    }

    public JedisConnection(Jedis jedis, Pool<Jedis> pool, int dbIndex) {
        this.jedis = jedis;
        this.client = (Client)ReflectionUtils.getField((Field)CLIENT_FIELD, (Object)jedis);
        this.transaction = new Transaction(this.client);
        this.pool = pool;
        this.dbIndex = dbIndex;
        if (dbIndex > 0) {
            this.select(dbIndex);
        }
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        if (ex instanceof JedisException) {
            if (ex instanceof JedisConnectionException) {
                this.broken = true;
            }
            return JedisUtils.convertJedisAccessException((JedisException)ex);
        }
        if (ex instanceof IOException) {
            return JedisUtils.convertJedisAccessException((IOException)ex);
        }
        return new RedisSystemException("Unknown jedis exception", ex);
    }

    @Override
    public void close() throws DataAccessException {
        try {
            if (this.pool != null) {
                if (this.broken) {
                    this.pool.returnBrokenResource((Object)this.jedis);
                } else {
                    if (this.dbIndex > 0) {
                        this.select(0);
                    }
                    this.pool.returnResource((Object)this.jedis);
                }
            }
        }
        catch (Exception ex) {
            this.pool.returnBrokenResource((Object)this.jedis);
        }
        if (this.pool != null) {
            return;
        }
        try {
            if (this.isQueueing()) {
                this.client.quit();
                this.client.disconnect();
                return;
            }
            this.jedis.quit();
            this.jedis.disconnect();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    public Jedis getNativeConnection() {
        return this.jedis;
    }

    @Override
    public boolean isClosed() {
        try {
            return !this.jedis.isConnected();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public boolean isQueueing() {
        return this.client.isInMulti();
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.jedis.pipelined();
        }
    }

    @Override
    public List<Object> closePipeline() {
        List execute;
        if (this.pipeline != null && (execute = this.pipeline.syncAndReturnAll()) != null && !execute.isEmpty()) {
            return execute;
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> sort(byte[] key, SortParameters params) {
        SortingParams sortParams = JedisUtils.convertSortParams(params);
        try {
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction.sort(key, sortParams);
                } else {
                    this.transaction.sort(key);
                }
                return null;
            }
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline.sort(key, sortParams);
                } else {
                    this.pipeline.sort(key);
                }
                return null;
            }
            return sortParams != null ? this.jedis.sort(key, sortParams) : this.jedis.sort(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] sortKey) {
        SortingParams sortParams = JedisUtils.convertSortParams(params);
        try {
            if (this.isQueueing()) {
                if (sortParams != null) {
                    this.transaction.sort(key, sortParams, sortKey);
                } else {
                    this.transaction.sort(key, sortKey);
                }
                return null;
            }
            if (this.isPipelined()) {
                if (sortParams != null) {
                    this.pipeline.sort(key, sortParams, sortKey);
                } else {
                    this.pipeline.sort(key, sortKey);
                }
                return null;
            }
            return sortParams != null ? this.jedis.sort(key, sortParams, sortKey) : this.jedis.sort(key, sortKey);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            return this.jedis.dbSize();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.jedis.flushDB();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.jedis.flushAll();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.bgsave();
                return;
            }
            this.jedis.bgsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void bgWriteAof() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.bgrewriteaof();
                return;
            }
            this.jedis.bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.save();
                return;
            }
            this.jedis.save();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<String> getConfig(String param) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.configGet(param);
                return null;
            }
            return this.jedis.configGet(param);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            return JedisUtils.info(this.jedis.info());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.lastsave();
                return null;
            }
            return this.jedis.lastsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.configSet(param, value);
                return;
            }
            this.jedis.configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.configResetStat();
                return;
            }
            this.jedis.configResetStat();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.jedis.shutdown();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] echo(byte[] message) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.echo(message);
                return null;
            }
            return this.jedis.echo(message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public String ping() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            return this.jedis.ping();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long del(byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.del(keys);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.del(keys);
                return null;
            }
            return this.jedis.del(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void discard() {
        try {
            this.client.discard();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Object> exec() {
        try {
            if (this.isPipelined()) {
                this.pipeline.exec();
                return null;
            }
            return this.transaction.exec();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean exists(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.exists(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.exists(key);
                return null;
            }
            return this.jedis.exists(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expire(byte[] key, long seconds) {
        try {
            if (this.isQueueing()) {
                this.transaction.expire(key, (int)seconds);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.expire(key, (int)seconds);
                return null;
            }
            return this.jedis.expire(key, (int)seconds) == 1L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte[] key, long unixTime) {
        try {
            if (this.isQueueing()) {
                this.transaction.expireAt(key, unixTime);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.expireAt(key, unixTime);
                return null;
            }
            return this.jedis.expireAt(key, unixTime) == 1L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        try {
            if (this.isQueueing()) {
                this.transaction.keys(pattern);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.keys(pattern);
                return null;
            }
            return this.jedis.keys(pattern);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        try {
            if (this.isPipelined()) {
                this.pipeline.multi();
                return;
            }
            this.jedis.multi();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.client.persist(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.persist(key);
                return null;
            }
            return this.jedis.persist(key) == 1L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        try {
            if (this.isQueueing()) {
                this.client.move(key, dbIndex);
                return null;
            }
            if (this.isPipelined()) {
                this.client.move(key, dbIndex);
                return null;
            }
            return this.jedis.move(key, dbIndex) == 1L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] randomKey() {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            return this.jedis.randomBinaryKey();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        try {
            if (this.isQueueing()) {
                this.transaction.rename(oldName, newName);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.rename(oldName, newName);
                return;
            }
            this.jedis.rename(oldName, newName);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        try {
            if (this.isQueueing()) {
                this.transaction.renamenx(oldName, newName);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.renamenx(oldName, newName);
                return null;
            }
            return this.jedis.renamenx(oldName, newName) == 1L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void select(int dbIndex) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.jedis.select(dbIndex);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.ttl(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.ttl(key);
                return null;
            }
            return this.jedis.ttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public DataType type(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.type(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.type(key);
                return null;
            }
            return DataType.fromCode(this.jedis.type(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void unwatch() {
        try {
            this.jedis.unwatch();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            for (byte[] key : keys) {
                if (this.isPipelined()) {
                    this.pipeline.watch((byte[][])new byte[][]{key});
                    continue;
                }
                this.jedis.watch((byte[][])new byte[][]{key});
            }
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.get(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.get(key);
                return null;
            }
            return this.jedis.get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void set(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.set(key, value);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.set(key, value);
                return;
            }
            this.jedis.set(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.getSet(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.getSet(key, value);
                return null;
            }
            return this.jedis.getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.append(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.append(key, value);
                return null;
            }
            return this.jedis.append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.mget(keys);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.mget(keys);
                return null;
            }
            return this.jedis.mget(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void mSet(Map<byte[], byte[]> tuples) {
        try {
            if (this.isQueueing()) {
                this.transaction.mset(JedisUtils.convert(tuples));
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.mset(JedisUtils.convert(tuples));
                return;
            }
            this.jedis.mset(JedisUtils.convert(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void mSetNX(Map<byte[], byte[]> tuples) {
        try {
            if (this.isQueueing()) {
                this.transaction.msetnx(JedisUtils.convert(tuples));
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.msetnx(JedisUtils.convert(tuples));
                return;
            }
            this.jedis.msetnx(JedisUtils.convert(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setEx(byte[] key, long time, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.setex(key, (int)time, value);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.setex(key, (int)time, value);
                return;
            }
            this.jedis.setex(key, (int)time, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.setnx(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.setnx(key, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.substr(key, (int)start, (int)end);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.substr(key, (int)start, (int)end);
                return null;
            }
            return this.jedis.substr(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.decr(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.decr(key);
                return null;
            }
            return this.jedis.decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        try {
            if (this.isQueueing()) {
                this.transaction.decrBy(key, (long)((int)value));
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.decrBy(key, (long)((int)value));
                return null;
            }
            return this.jedis.decrBy(key, (long)((int)value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.incr(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.incr(key);
                return null;
            }
            return this.jedis.incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        try {
            if (this.isQueueing()) {
                this.transaction.incrBy(key, (long)((int)value));
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.incrBy(key, (long)((int)value));
                return null;
            }
            return this.jedis.incrBy(key, (long)((int)value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            return this.jedis.getbit(key, offset) == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setBit(byte[] key, long offset, boolean value) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.jedis.setbit(key, offset, JedisUtils.asBit(value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long start) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            this.jedis.setrange(key, start, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.strlen(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.strlen(key);
                return null;
            }
            return this.jedis.strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPush(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.lpush(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.lpush(key, value);
                return null;
            }
            return this.jedis.lpush(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPush(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.rpush(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.rpush(key, value);
                return null;
            }
            return this.jedis.rpush(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.blpop(JedisUtils.bXPopArgs(timeout, keys));
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.blpop(JedisUtils.bXPopArgs(timeout, keys));
                return null;
            }
            return this.jedis.blpop(timeout, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.brpop(JedisUtils.bXPopArgs(timeout, keys));
            }
            if (this.isPipelined()) {
                this.pipeline.brpop(JedisUtils.bXPopArgs(timeout, keys));
                return null;
            }
            return this.jedis.brpop(timeout, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lIndex(byte[] key, long index) {
        try {
            if (this.isQueueing()) {
                this.transaction.lindex(key, (long)((int)index));
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.lindex(key, (int)index);
                return null;
            }
            return this.jedis.lindex(key, (int)index);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.linsert(key, JedisUtils.convertPosition(where), pivot, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.linsert(key, JedisUtils.convertPosition(where), pivot, value);
                return null;
            }
            return this.jedis.linsert(key, JedisUtils.convertPosition(where), pivot, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lLen(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.llen(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.llen(key);
                return null;
            }
            return this.jedis.llen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] lPop(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.lpop(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.lpop(key);
                return null;
            }
            return this.jedis.lpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> lRange(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.lrange(key, (long)((int)start), (long)((int)end));
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.lrange(key, (long)((int)start), (long)((int)end));
                return null;
            }
            return this.jedis.lrange(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lRem(byte[] key, long count, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.lrem(key, (long)((int)count), value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.lrem(key, (long)((int)count), value);
                return null;
            }
            return this.jedis.lrem(key, (int)count, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lSet(byte[] key, long index, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.lset(key, (long)((int)index), value);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.lset(key, (long)((int)index), value);
                return;
            }
            this.jedis.lset(key, (int)index, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void lTrim(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.ltrim(key, (long)((int)start), (long)((int)end));
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.ltrim(key, (long)((int)start), (long)((int)end));
                return;
            }
            this.jedis.ltrim(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPop(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.rpop(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.rpop(key);
                return null;
            }
            return this.jedis.rpop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isQueueing()) {
                this.transaction.rpoplpush(srcKey, dstKey);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.rpoplpush(srcKey, dstKey);
                return null;
            }
            return this.jedis.rpoplpush(srcKey, dstKey);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        try {
            if (this.isQueueing()) {
                this.transaction.brpoplpush(srcKey, dstKey, timeout);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.brpoplpush(srcKey, dstKey, timeout);
                return null;
            }
            return this.jedis.brpoplpush(srcKey, dstKey, timeout);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lPushX(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.lpushx(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.lpushx(key, value);
                return null;
            }
            return this.jedis.lpushx(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long rPushX(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.rpushx(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.rpushx(key, value);
                return null;
            }
            return this.jedis.rpushx(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sAdd(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.sadd(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.sadd(key, value);
                return null;
            }
            return this.jedis.sadd(key, value) == 1L;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sCard(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.scard(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.scard(key);
                return null;
            }
            return this.jedis.scard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sDiff(byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.sdiff(keys);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.sdiff(keys);
                return null;
            }
            return this.jedis.sdiff(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void sDiffStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.sdiffstore(destKey, keys);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.sdiffstore(destKey, keys);
                return;
            }
            this.jedis.sdiffstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sInter(byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.sinter(keys);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.sinter(keys);
                return null;
            }
            return this.jedis.sinter(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void sInterStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.sinterstore(destKey, keys);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.sinterstore(destKey, keys);
                return;
            }
            this.jedis.sinterstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sIsMember(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.sismember(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.sismember(key, value);
                return null;
            }
            return this.jedis.sismember(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sMembers(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.smembers(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.smembers(key);
                return null;
            }
            return this.jedis.smembers(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.smove(srcKey, destKey, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.smove(srcKey, destKey, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.smove(srcKey, destKey, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sPop(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.spop(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.spop(key);
                return null;
            }
            return this.jedis.spop(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] sRandMember(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.srandmember(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.srandmember(key);
                return null;
            }
            return this.jedis.srandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean sRem(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.srem(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.srem(key, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.srem(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> sUnion(byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.sunion(keys);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.sunion(keys);
                return null;
            }
            return this.jedis.sunion(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void sUnionStore(byte[] destKey, byte[] ... keys) {
        try {
            if (this.isQueueing()) {
                this.transaction.sunionstore(destKey, keys);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.sunionstore(destKey, keys);
                return;
            }
            this.jedis.sunionstore(destKey, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.zadd(key, score, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zadd(key, score, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.zcard(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zcard(key);
                return null;
            }
            return this.jedis.zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                this.transaction.zcount(key, min, max);
                return null;
            }
            if (this.isQueueing()) {
                this.pipeline.zcount(key, min, max);
                return null;
            }
            return this.jedis.zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.zincrby(key, increment, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zincrby(key, increment, value);
                return null;
            }
            return this.jedis.zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isQueueing()) {
                this.transaction.zinterstore(destKey, zparams, sets);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zinterstore(destKey, zparams, sets);
                return null;
            }
            return this.jedis.zinterstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isQueueing()) {
                this.transaction.zinterstore(destKey, sets);
                return null;
            }
            if (this.isQueueing()) {
                this.pipeline.zinterstore(destKey, sets);
                return null;
            }
            return this.jedis.zinterstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrange(key, (int)start, (int)end);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrange(key, (int)start, (int)end);
                return null;
            }
            return this.jedis.zrange(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrangeWithScores(key, (int)start, (int)end);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrangeWithScores(key, (int)start, (int)end);
                return null;
            }
            return JedisUtils.convertJedisTuple(this.jedis.zrangeWithScores(key, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrangeByScore(key, min, max);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrangeByScore(key, min, max);
                return null;
            }
            return this.jedis.zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrangeByScoreWithScores(key, min, max);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrangeByScoreWithScores(key, min, max);
                return null;
            }
            return JedisUtils.convertJedisTuple(this.jedis.zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrevrangeWithScores(key, (int)start, (int)end);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrevrangeWithScores(key, (int)start, (int)end);
                return null;
            }
            return JedisUtils.convertJedisTuple(this.jedis.zrevrangeWithScores(key, (int)start, (int)end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrangeByScore(key, min, max, (int)offset, (int)count);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrangeByScore(key, min, max, (int)offset, (int)count);
                return null;
            }
            return this.jedis.zrangeByScore(key, min, max, (int)offset, (int)count);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrangeByScoreWithScores(key, min, max, (int)offset, (int)count);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrangeByScoreWithScores(key, min, max, (int)offset, (int)count);
                return null;
            }
            return JedisUtils.convertJedisTuple(this.jedis.zrangeByScoreWithScores(key, min, max, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max, long offset, long count) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrank(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrank(key, value);
                return null;
            }
            return this.jedis.zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean zRem(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrem(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrem(key, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.zrem(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.zremrangeByRank(key, (int)start, (int)end);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zremrangeByRank(key, (int)start, (int)end);
                return null;
            }
            return this.jedis.zremrangeByRank(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, double min, double max) {
        try {
            if (this.isQueueing()) {
                this.transaction.zremrangeByScore(key, min, max);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zremrangeByScore(key, min, max);
                return null;
            }
            return this.jedis.zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrevrange(key, (int)start, (int)end);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrevrange(key, (int)start, (int)end);
                return null;
            }
            return this.jedis.zrevrange(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.zrevrank(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zrevrank(key, value);
                return null;
            }
            return this.jedis.zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.zscore(key, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zscore(key, value);
                return null;
            }
            return this.jedis.zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isQueueing()) {
                this.transaction.zunionstore(destKey, zparams, sets);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zunionstore(destKey, zparams, sets);
                return null;
            }
            return this.jedis.zunionstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        try {
            if (this.isQueueing()) {
                this.transaction.zunionstore(destKey, sets);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.zunionstore(destKey, sets);
                return null;
            }
            return this.jedis.zunionstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.hset(key, field, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hset(key, field, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.hset(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        try {
            if (this.isQueueing()) {
                this.transaction.hsetnx(key, field, value);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hsetnx(key, field, value);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.hsetnx(key, field, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hDel(byte[] key, byte[] field) {
        try {
            if (this.isQueueing()) {
                this.transaction.hdel(key, field);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hdel(key, field);
                return null;
            }
            return JedisUtils.convertCodeReply(this.jedis.hdel(key, field));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        try {
            if (this.isQueueing()) {
                this.transaction.hexists(key, field);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hexists(key, field);
                return null;
            }
            return this.jedis.hexists(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        try {
            if (this.isQueueing()) {
                this.transaction.hget(key, field);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hget(key, field);
                return null;
            }
            return this.jedis.hget(key, field);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.hgetAll(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hgetAll(key);
                return null;
            }
            return this.jedis.hgetAll(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        try {
            if (this.isQueueing()) {
                this.transaction.hincrBy(key, field, (long)((int)delta));
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hincrBy(key, field, (long)((int)delta));
                return null;
            }
            return this.jedis.hincrBy(key, field, (long)((int)delta));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.hkeys(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hkeys(key);
                return null;
            }
            return this.jedis.hkeys(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long hLen(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.hlen(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hlen(key);
                return null;
            }
            return this.jedis.hlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        try {
            if (this.isQueueing()) {
                this.transaction.hmget(key, fields);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hmget(key, fields);
                return null;
            }
            return this.jedis.hmget(key, fields);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> tuple) {
        try {
            if (this.isQueueing()) {
                this.transaction.hmset(key, tuple);
                return;
            }
            if (this.isPipelined()) {
                this.pipeline.hmset(key, tuple);
                return;
            }
            this.jedis.hmset(key, tuple);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        try {
            if (this.isQueueing()) {
                this.transaction.hvals(key);
                return null;
            }
            if (this.isPipelined()) {
                this.pipeline.hvals(key);
                return null;
            }
            return new ArrayList<byte[]>(this.jedis.hvals(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                this.pipeline.publish(channel, message);
                return null;
            }
            return this.jedis.publish(channel, message);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            BinaryJedisPubSub jedisPubSub = JedisUtils.adaptPubSub(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            this.jedis.psubscribe(jedisPubSub, patterns);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        try {
            if (this.isQueueing()) {
                throw new UnsupportedOperationException();
            }
            if (this.isPipelined()) {
                throw new UnsupportedOperationException();
            }
            BinaryJedisPubSub jedisPubSub = JedisUtils.adaptPubSub(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            this.jedis.subscribe(jedisPubSub, channels);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private void checkSubscription() {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Cannot execute command - connection is subscribed");
        }
    }

    static {
        ReflectionUtils.makeAccessible((Field)CLIENT_FIELD);
    }
}

