/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.data.jpa.provider.HibernateUtils;
import org.springframework.data.jpa.provider.JpaClassUtils;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public enum PersistenceProvider implements QueryExtractor,
ProxyIdAccessor
{
    HIBERNATE(Collections.singletonList("org.hibernate.jpa.HibernateEntityManager"), Collections.singletonList("org.hibernate.metamodel.internal.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return HibernateUtils.getHibernateQuery(query);
        }

        @Override
        public String getCountQueryPlaceholder() {
            return "*";
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return entity instanceof HibernateProxy;
        }

        @Override
        public Object getIdentifierFrom(Object entity) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }

        @Override
        @Nullable
        public <T> Collection<T> potentiallyConvertEmptyCollection(@Nullable Collection<T> collection) {
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new HibernateScrollableResultsIterator(jpaQuery);
        }
    }
    ,
    ECLIPSELINK(Collections.singleton("org.eclipse.persistence.jpa.JpaEntityManager"), Collections.singleton("org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl")){

        @Override
        public String extractQueryString(Query query) {
            return ((JpaQuery)query).getDatabaseQuery().getJPQLString();
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        @Nullable
        public Object getIdentifierFrom(Object entity) {
            return null;
        }

        @Override
        @Nullable
        public <T> Collection<T> potentiallyConvertEmptyCollection(@Nullable Collection<T> collection) {
            return collection == null || collection.isEmpty() ? null : collection;
        }

        @Override
        public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
            return new EclipseLinkScrollableResultsIterator<Object>(jpaQuery);
        }
    }
    ,
    GENERIC_JPA(Collections.singleton("javax.persistence.EntityManager"), Collections.emptySet()){

        @Override
        @Nullable
        public String extractQueryString(Query query) {
            return null;
        }

        @Override
        public boolean canExtractQuery() {
            return false;
        }

        @Override
        public boolean shouldUseAccessorFor(Object entity) {
            return false;
        }

        @Override
        @Nullable
        public Object getIdentifierFrom(Object entity) {
            return null;
        }
    };

    static ConcurrentReferenceHashMap<Class<?>, PersistenceProvider> CACHE;
    private final Iterable<String> entityManagerClassNames;
    private final Iterable<String> metamodelClassNames;

    private PersistenceProvider(Iterable<String> entityManagerClassNames, Iterable<String> metamodelClassNames) {
        this.entityManagerClassNames = entityManagerClassNames;
        this.metamodelClassNames = metamodelClassNames;
    }

    private static PersistenceProvider cacheAndReturn(Class<?> type, PersistenceProvider provider) {
        CACHE.put(type, (Object)provider);
        return provider;
    }

    public static PersistenceProvider fromEntityManager(EntityManager em) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Class<?> entityManagerType = em.getDelegate().getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(entityManagerType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String entityManagerClassName : provider.entityManagerClassNames) {
                if (!JpaClassUtils.isEntityManagerOfType(em, entityManagerClassName)) continue;
                return PersistenceProvider.cacheAndReturn(entityManagerType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(entityManagerType, GENERIC_JPA);
    }

    public static PersistenceProvider fromMetamodel(Metamodel metamodel) {
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        Class<?> metamodelType = metamodel.getClass();
        PersistenceProvider cachedProvider = (PersistenceProvider)CACHE.get(metamodelType);
        if (cachedProvider != null) {
            return cachedProvider;
        }
        for (PersistenceProvider provider : PersistenceProvider.values()) {
            for (String metamodelClassName : provider.metamodelClassNames) {
                if (!JpaClassUtils.isMetamodelOfType(metamodel, metamodelClassName)) continue;
                return PersistenceProvider.cacheAndReturn(metamodelType, provider);
            }
        }
        return PersistenceProvider.cacheAndReturn(metamodelType, GENERIC_JPA);
    }

    public String getCountQueryPlaceholder() {
        return "x";
    }

    @Override
    public boolean canExtractQuery() {
        return true;
    }

    @Nullable
    public <T> Collection<T> potentiallyConvertEmptyCollection(@Nullable Collection<T> collection) {
        return collection;
    }

    public CloseableIterator<Object> executeQueryWithResultStream(Query jpaQuery) {
        throw new UnsupportedOperationException("Streaming results is not implement for this PersistenceProvider: " + this.name());
    }

    static {
        CACHE = new ConcurrentReferenceHashMap();
    }

    private static class EclipseLinkScrollableResultsIterator<T>
    implements CloseableIterator<T> {
        @Nullable
        private final ScrollableCursor scrollableCursor;

        EclipseLinkScrollableResultsIterator(Query jpaQuery) {
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            this.scrollableCursor = (ScrollableCursor)jpaQuery.getSingleResult();
        }

        public boolean hasNext() {
            return this.scrollableCursor != null && this.scrollableCursor.hasNext();
        }

        public T next() {
            if (this.scrollableCursor == null) {
                throw new NoSuchElementException("No ScrollableCursor");
            }
            return (T)this.scrollableCursor.next();
        }

        public void close() {
            if (this.scrollableCursor != null) {
                this.scrollableCursor.close();
            }
        }
    }

    private static class HibernateScrollableResultsIterator
    implements CloseableIterator<Object> {
        @Nullable
        private final ScrollableResults scrollableResults;

        HibernateScrollableResultsIterator(Query jpaQuery) {
            org.hibernate.query.Query query = (org.hibernate.query.Query)jpaQuery.unwrap(org.hibernate.query.Query.class);
            this.scrollableResults = query.setReadOnly(TransactionSynchronizationManager.isCurrentTransactionReadOnly()).scroll(ScrollMode.FORWARD_ONLY);
        }

        public Object next() {
            if (this.scrollableResults == null) {
                throw new NoSuchElementException("No ScrollableResults");
            }
            Object[] row = this.scrollableResults.get();
            return row.length == 1 ? row[0] : row;
        }

        public boolean hasNext() {
            return this.scrollableResults != null && this.scrollableResults.next();
        }

        public void close() {
            if (this.scrollableResults != null) {
                this.scrollableResults.close();
            }
        }
    }

    static interface Constants {
        public static final String GENERIC_JPA_ENTITY_MANAGER_INTERFACE = "javax.persistence.EntityManager";
        public static final String ECLIPSELINK_ENTITY_MANAGER_INTERFACE = "org.eclipse.persistence.jpa.JpaEntityManager";
        public static final String HIBERNATE_ENTITY_MANAGER_INTERFACE = "org.hibernate.jpa.HibernateEntityManager";
        public static final String HIBERNATE_JPA_METAMODEL_TYPE = "org.hibernate.metamodel.internal.MetamodelImpl";
        public static final String ECLIPSELINK_JPA_METAMODEL_TYPE = "org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl";
    }
}

