/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.persistence.Access;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.persistence.metamodel.Metamodel;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.annotation.AccessType;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpaPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<JpaPersistentProperty>
implements JpaPersistentProperty {
    private static final Collection<Class<? extends Annotation>> ASSOCIATION_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> ID_ANNOTATIONS;
    private static final Collection<Class<? extends Annotation>> UPDATEABLE_ANNOTATIONS;
    @Nullable
    private final Boolean usePropertyAccess;
    @Nullable
    private final TypeInformation<?> associationTargetType;
    private final boolean updateable;
    private final JpaMetamodel metamodel;
    private final Lazy<Boolean> isIdProperty;

    public JpaPersistentPropertyImpl(Metamodel metamodel, Property property, PersistentEntity<?, JpaPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null!");
        this.usePropertyAccess = this.detectPropertyAccess();
        this.associationTargetType = this.detectAssociationTargetType();
        this.updateable = this.detectUpdatability();
        this.metamodel = new JpaMetamodel(metamodel);
        this.isIdProperty = Lazy.of(() -> ID_ANNOTATIONS.stream().anyMatch(it -> this.isAnnotationPresent((Class)it)) || this.metamodel.isSingleIdAttribute(this.getOwner().getType(), this.getName(), this.getType()));
    }

    public Class<?> getActualType() {
        return this.associationTargetType != null ? this.associationTargetType.getType() : super.getActualType();
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        return this.associationTargetType != null ? Collections.singleton(this.associationTargetType) : super.getPersistentEntityType();
    }

    public boolean isIdProperty() {
        return (Boolean)this.isIdProperty.get();
    }

    public boolean isEntity() {
        return this.metamodel.isJpaManaged(this.getActualType());
    }

    public boolean isAssociation() {
        for (Class<? extends Annotation> annotationType : ASSOCIATION_ANNOTATIONS) {
            if (this.findAnnotation(annotationType) == null) continue;
            return true;
        }
        return this.getType().isAnnotationPresent(Embeddable.class);
    }

    public boolean isTransient() {
        return this.isAnnotationPresent(Transient.class) || super.isTransient();
    }

    protected Association<JpaPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean usePropertyAccess() {
        return this.usePropertyAccess != null ? this.usePropertyAccess.booleanValue() : super.usePropertyAccess();
    }

    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    public boolean isWritable() {
        return this.updateable && super.isWritable();
    }

    @Nullable
    private Boolean detectPropertyAccess() {
        AccessType accessType = (AccessType)this.findAnnotation(AccessType.class);
        if (accessType != null) {
            return AccessType.Type.PROPERTY.equals((Object)accessType.value());
        }
        Access access = (Access)this.findAnnotation(Access.class);
        if (access != null) {
            return javax.persistence.AccessType.PROPERTY.equals((Object)access.value());
        }
        accessType = (AccessType)this.findPropertyOrOwnerAnnotation(AccessType.class);
        if (accessType != null) {
            return AccessType.Type.PROPERTY.equals((Object)accessType.value());
        }
        access = (Access)this.findPropertyOrOwnerAnnotation(Access.class);
        if (access != null) {
            return javax.persistence.AccessType.PROPERTY.equals((Object)access.value());
        }
        return null;
    }

    @Nullable
    private TypeInformation<?> detectAssociationTargetType() {
        if (!this.isAssociation()) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : ASSOCIATION_ANNOTATIONS) {
            Object entityValue;
            Annotation annotation = this.findAnnotation(annotationType);
            if (annotation == null || (entityValue = AnnotationUtils.getValue((Annotation)annotation, (String)"targetEntity")) == null || entityValue.equals(Void.TYPE)) continue;
            return ClassTypeInformation.from((Class)((Class)entityValue));
        }
        return null;
    }

    private boolean detectUpdatability() {
        for (Class<? extends Annotation> annotationType : UPDATEABLE_ANNOTATIONS) {
            Annotation annotation = this.findAnnotation(annotationType);
            if (annotation == null) continue;
            return (Boolean)AnnotationUtils.getValue((Annotation)annotation, (String)"updatable");
        }
        return true;
    }

    static {
        HashSet<Class<OrderColumn>> annotations = new HashSet<Class<OrderColumn>>();
        annotations.add(OneToMany.class);
        annotations.add(OneToOne.class);
        annotations.add(ManyToMany.class);
        annotations.add(ManyToOne.class);
        annotations.add(Embedded.class);
        ASSOCIATION_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Id.class);
        annotations.add(EmbeddedId.class);
        ID_ANNOTATIONS = Collections.unmodifiableSet(annotations);
        annotations = new HashSet();
        annotations.add(Column.class);
        annotations.add(OrderColumn.class);
        UPDATEABLE_ANNOTATIONS = Collections.unmodifiableSet(annotations);
    }
}

