/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class StreamEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";
    static String[] headers = new String[]{"spanId", "spanTraceId", "spanParentSpanId", "spanProcessId", "spanSampled", "spanName"};

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ResourceLoader resourceLoader = application.getResourceLoader();
        resourceLoader = resourceLoader == null ? new DefaultResourceLoader() : resourceLoader;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(resourceLoader);
        try {
            for (Resource resource : resolver.getResources("classpath*:META-INF/spring.binders")) {
                for (String binderType : this.parseBinderConfigurations(resource)) {
                    int startIndex = this.findStartIndex(environment, binderType);
                    this.addHeaders(map, environment.getPropertySources(), binderType, startIndex);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load META-INF/spring.binders", e);
        }
        map.put("spring.cloud.stream.bindings.sleuth.group", environment.getProperty("spring.sleuth.stream.group", "sleuth"));
        map.put("spring.cloud.stream.bindings.sleuth.content-type", environment.getProperty("spring.sleuth.stream.content-type", "application/json"));
        this.addOrReplace(environment.getPropertySources(), map);
    }

    private int findStartIndex(ConfigurableEnvironment environment, String binder) {
        String prefix = "spring.cloud.stream." + binder + ".binder.headers";
        int i = 0;
        while (environment.getProperty(prefix + "[" + i + "]") != null) {
            ++i;
        }
        return i;
    }

    private Collection<String> parseBinderConfigurations(Resource resource) {
        HashSet<String> keys = new HashSet<String>();
        try {
            Properties props = PropertiesLoaderUtils.loadProperties((Resource)resource);
            for (Object object : props.keySet()) {
                keys.add(object.toString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return keys;
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }

    private void addHeaders(Map<String, Object> map, MutablePropertySources propertySources, String binder, int startIndex) {
        String stem = "spring.cloud.stream." + binder + ".binder.headers";
        for (int i = 0; i < headers.length; ++i) {
            if (this.hasTracingHeadersValue(propertySources, headers[i])) continue;
            map.put(stem + "[" + (i + startIndex) + "]", headers[i]);
        }
    }

    private boolean hasTracingHeadersValue(MutablePropertySources propertySources, String header) {
        PropertySource source = propertySources.get(PROPERTY_SOURCE_NAME);
        if (source instanceof MapPropertySource) {
            Collection values = ((Map)((MapPropertySource)source).getSource()).values();
            return values.contains(header);
        }
        return false;
    }
}

