/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.serviceregistry;

import com.netflix.appinfo.InstanceInfo;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;

public class EurekaServiceRegistry
implements ServiceRegistry<EurekaRegistration> {
    private static final Log log = LogFactory.getLog(EurekaServiceRegistry.class);

    public void register(EurekaRegistration reg) {
        this.maybeInitializeClient(reg);
        if (log.isInfoEnabled()) {
            log.info((Object)("Registering application " + reg.getInstanceConfig().getAppname() + " with eureka with status " + reg.getInstanceConfig().getInitialStatus()));
        }
        reg.getApplicationInfoManager().setInstanceStatus(reg.getInstanceConfig().getInitialStatus());
        if (reg.getHealthCheckHandler() != null) {
            reg.getEurekaClient().registerHealthCheck(reg.getHealthCheckHandler());
        }
    }

    private void maybeInitializeClient(EurekaRegistration reg) {
        reg.getApplicationInfoManager().getInfo();
        reg.getEurekaClient().getApplications();
    }

    public void deregister(EurekaRegistration reg) {
        if (reg.getApplicationInfoManager().getInfo() != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unregistering application " + reg.getInstanceConfig().getAppname() + " with eureka with status DOWN"));
            }
            reg.getApplicationInfoManager().setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
            reg.getEurekaClient().shutdown();
        }
    }

    public void setStatus(EurekaRegistration registration, String status) {
        InstanceInfo info = registration.getApplicationInfoManager().getInfo();
        if ("CANCEL_OVERRIDE".equalsIgnoreCase(status)) {
            registration.getEurekaClient().cancelOverrideStatus(info);
            return;
        }
        InstanceInfo.InstanceStatus newStatus = InstanceInfo.InstanceStatus.toEnum((String)status);
        registration.getEurekaClient().setStatus(newStatus, info);
    }

    public Object getStatus(EurekaRegistration registration) {
        HashMap<String, String> status = new HashMap<String, String>();
        InstanceInfo info = registration.getApplicationInfoManager().getInfo();
        status.put("status", info.getStatus().toString());
        status.put("overriddenStatus", info.getOverriddenStatus().toString());
        return status;
    }

    public void close() {
    }
}

