/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client;

import java.util.List;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryCompositeHealthIndicator;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={DiscoveryClient.class})
@ConditionalOnProperty(value={"spring.cloud.discovery.enabled"}, matchIfMissing=true)
@Order(value=0)
public class CommonsClientAutoConfiguration {
    @Bean
    public DiscoveryClientHealthIndicator instancesHealthIndicator(DiscoveryClient discoveryClient) {
        return new DiscoveryClientHealthIndicator(discoveryClient);
    }

    @Bean
    public DiscoveryCompositeHealthIndicator discoveryHealthIndicator(HealthAggregator aggregator, List<DiscoveryHealthIndicator> indicators) {
        return new DiscoveryCompositeHealthIndicator(aggregator, indicators);
    }
}

