/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.file.transform.DefaultFieldSetFactory;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.FieldSetFactory;
import org.springframework.batch.item.file.transform.IncorrectTokenCountException;
import org.springframework.batch.item.file.transform.LineTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLineTokenizer
implements LineTokenizer {
    protected String[] names = new String[0];
    private boolean strict = true;
    private String emptyToken = "";
    private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected boolean isStrict() {
        return this.strict;
    }

    public void setFieldSetFactory(FieldSetFactory fieldSetFactory) {
        this.fieldSetFactory = fieldSetFactory;
    }

    public void setNames(String[] names) {
        this.names = names == null ? null : Arrays.asList(names).toArray(new String[names.length]);
    }

    public boolean hasNames() {
        return this.names != null && this.names.length > 0;
    }

    @Override
    public FieldSet tokenize(String line) {
        if (line == null) {
            line = "";
        }
        ArrayList<String> tokens = new ArrayList<String>(this.doTokenize(line));
        if (this.names.length != 0 && !this.strict) {
            this.adjustTokenCountIfNecessary(tokens);
        }
        String[] values = tokens.toArray(new String[tokens.size()]);
        if (this.names.length == 0) {
            return this.fieldSetFactory.create(values);
        }
        if (values.length != this.names.length) {
            throw new IncorrectTokenCountException(this.names.length, values.length);
        }
        return this.fieldSetFactory.create(values, this.names);
    }

    protected abstract List<String> doTokenize(String var1);

    private void adjustTokenCountIfNecessary(List<String> tokens) {
        block4: {
            int nameLength = this.names.length;
            int tokensSize = tokens.size();
            if (nameLength == tokensSize) break block4;
            if (nameLength > tokensSize) {
                for (int i = 0; i < nameLength - tokensSize; ++i) {
                    tokens.add(this.emptyToken);
                }
            } else {
                for (int i = tokensSize - 1; i >= nameLength; --i) {
                    tokens.remove(i);
                }
            }
        }
    }
}

