/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;

public class LogLevelMapping {
    private static Map<Long, Level> levelMap;
    private static final String DEBUG = "DEBUG";

    public static Level toLevel(long longValue) {
        return levelMap.get(longValue);
    }

    public static Level toLevel(String logLevelName) {
        if (logLevelName == null || "".equals(logLevelName)) {
            return Level.INFO;
        }
        if (logLevelName.equals(DEBUG)) {
            return Level.FINE;
        }
        return levelMap.get(Level.parse(logLevelName).intValue());
    }

    static {
        Level[] supportedLevels = new Level[]{Level.ALL, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Level level : supportedLevels) {
            builder.put((Object)level.intValue(), (Object)level);
        }
        levelMap = builder.build();
    }
}

