/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions;

import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Keys;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.ActionChainsGenerator;
import org.openqa.selenium.interactions.ButtonReleaseAction;
import org.openqa.selenium.interactions.ClickAction;
import org.openqa.selenium.interactions.ClickAndHoldAction;
import org.openqa.selenium.interactions.CompositeAction;
import org.openqa.selenium.interactions.ContextClickAction;
import org.openqa.selenium.interactions.DoubleClickAction;
import org.openqa.selenium.interactions.KeyDownAction;
import org.openqa.selenium.interactions.KeyUpAction;
import org.openqa.selenium.interactions.MoveMouseAction;
import org.openqa.selenium.interactions.MoveToOffsetAction;
import org.openqa.selenium.interactions.SendKeysAction;
import org.openqa.selenium.internal.Locatable;

public class DefaultActionChainsGenerator
implements ActionChainsGenerator {
    protected Mouse mouse;
    protected Keyboard keyboard;
    private CompositeAction action;

    public DefaultActionChainsGenerator(WebDriver driver) {
        this(((HasInputDevices)((Object)driver)).getKeyboard(), ((HasInputDevices)((Object)driver)).getMouse());
    }

    public DefaultActionChainsGenerator(Keyboard keyboard, Mouse mouse) {
        this.mouse = mouse;
        this.keyboard = keyboard;
        this.action = new CompositeAction();
    }

    public DefaultActionChainsGenerator keyDown(Keys theKey) {
        return this.keyDown(null, theKey);
    }

    public DefaultActionChainsGenerator keyDown(WebElement element, Keys theKey) {
        this.action.addAction(new KeyDownAction(this.keyboard, this.mouse, (Locatable)((Object)element), theKey));
        return this;
    }

    public DefaultActionChainsGenerator keyUp(Keys theKey) {
        return this.keyUp(null, theKey);
    }

    public DefaultActionChainsGenerator keyUp(WebElement element, Keys theKey) {
        this.action.addAction(new KeyUpAction(this.keyboard, this.mouse, (Locatable)((Object)element), theKey));
        return this;
    }

    public DefaultActionChainsGenerator sendKeys(CharSequence ... keysToSend) {
        return this.sendKeys((WebElement)null, keysToSend);
    }

    public DefaultActionChainsGenerator sendKeys(WebElement element, CharSequence ... keysToSend) {
        this.action.addAction(new SendKeysAction(this.keyboard, this.mouse, (Locatable)((Object)element), keysToSend));
        return this;
    }

    public Action build() {
        CompositeAction toReturn = this.action;
        this.action = null;
        return toReturn;
    }

    public DefaultActionChainsGenerator clickAndHold(WebElement onElement) {
        this.action.addAction(new ClickAndHoldAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public DefaultActionChainsGenerator release(WebElement onElement) {
        this.action.addAction(new ButtonReleaseAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public DefaultActionChainsGenerator click(WebElement onElement) {
        this.action.addAction(new ClickAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public ActionChainsGenerator click() {
        return this.click(null);
    }

    public DefaultActionChainsGenerator doubleClick(WebElement onElement) {
        this.action.addAction(new DoubleClickAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public DefaultActionChainsGenerator moveToElement(WebElement toElement) {
        this.action.addAction(new MoveMouseAction(this.mouse, (Locatable)((Object)toElement)));
        return this;
    }

    public ActionChainsGenerator moveToElement(WebElement toElement, int xOffset, int yOffset) {
        this.action.addAction(new MoveToOffsetAction(this.mouse, (Locatable)((Object)toElement), xOffset, yOffset));
        return this;
    }

    public ActionChainsGenerator moveByOffset(int xOffset, int yOffset) {
        this.action.addAction(new MoveToOffsetAction(this.mouse, null, xOffset, yOffset));
        return this;
    }

    public DefaultActionChainsGenerator contextClick(WebElement onElement) {
        this.action.addAction(new ContextClickAction(this.mouse, (Locatable)((Object)onElement)));
        return this;
    }

    public DefaultActionChainsGenerator dragAndDrop(WebElement source, WebElement target) {
        this.action.addAction(new ClickAndHoldAction(this.mouse, (Locatable)((Object)source)));
        this.action.addAction(new MoveMouseAction(this.mouse, (Locatable)((Object)target)));
        this.action.addAction(new ButtonReleaseAction(this.mouse, (Locatable)((Object)target)));
        return this;
    }
}

