/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Base64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OutputType<T> {
    public static final OutputType<String> BASE64 = new OutputType<String>(){

        @Override
        public String convertFromBase64Png(String base64Png) {
            return base64Png;
        }
    };
    public static final OutputType<byte[]> BYTES = new OutputType<byte[]>(){

        @Override
        public byte[] convertFromBase64Png(String base64Png) {
            return new Base64Encoder().decode(base64Png);
        }
    };
    public static final OutputType<File> FILE = new OutputType<File>(){

        @Override
        public File convertFromBase64Png(String base64Png) {
            FileOutputStream fos = null;
            try {
                byte[] data = (byte[])BYTES.convertFromBase64Png(base64Png);
                File tmpFile = File.createTempFile("screenshot", ".png");
                tmpFile.deleteOnExit();
                fos = new FileOutputStream(tmpFile);
                fos.write(data);
                fos.close();
                File file = tmpFile;
                return file;
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    };

    public T convertFromBase64Png(String var1);
}

